/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration.loader.nodeloaders;

import com.jronimo.systemconfiguration.BusinessObject;
import com.jronimo.systemconfiguration.BusinessObjectOperation;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;

public class BusinessObjectNodeLoader {
    private static final Logger logger = Logger.getLogger(BusinessObjectNodeLoader.class);
    private XmlElement element;

    public BusinessObjectNodeLoader(XmlElement xmlElement) {
        this.element = xmlElement;
    }

    public BusinessObject execute() throws Exception {
        BusinessObject businessObject = null;
        businessObject = new BusinessObject(this.element.getText("identifier"), this.element.getText("comments"));
        this.loadOperations(this.element.getElement("operations"), businessObject);
        return businessObject;
    }

    private void loadOperations(XmlElement xmlElement, BusinessObject businessObject) {
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("operation")) {
            this.loadOperation(xmlElement2, businessObject);
        }
    }

    private void loadOperation(XmlElement xmlElement, BusinessObject businessObject) {
        BusinessObjectOperation businessObjectOperation = null;
        BusinessObjectOperation.Parameter parameter = null;
        businessObjectOperation = new BusinessObjectOperation(xmlElement.getText("name"), xmlElement.getText("comments"));
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("protocols/protocol")) {
            businessObjectOperation.addProtocol(xmlElement2.getText());
        }
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("parameters/parameter")) {
            parameter = new BusinessObjectOperation.Parameter(xmlElement2.getText("name"), xmlElement2.getText("type"));
            businessObjectOperation.addParameter(parameter);
        }
        businessObject.addOperation(businessObjectOperation);
    }
}

