/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration.loader.legacy;

import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.SystemRole;
import com.jronimo.systemconfiguration.loader.legacy.LoaderAssist;
import com.jronimo.systemconfiguration.loader.nodeloaders.DataSourcesNodeLoader;
import com.jronimo.systemconfiguration.loader.nodeloaders.LanguagesNodeLoader;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;

public class LoaderAssistLoader {
    private static final Logger logger = Logger.getLogger(LoaderAssistLoader.class);
    public static XmlElement relationshipElement;
    private File loaderAssistFile;

    public LoaderAssistLoader(File file) {
        this.loaderAssistFile = file;
    }

    public LoaderAssist execute() throws Exception {
        LoaderAssist loaderAssist = null;
        XmlElement xmlElement = null;
        String string = null;
        LoaderAssist.LanguagesStruct languagesStruct = null;
        Constants.DataSourceEngine dataSourceEngine = null;
        String string2 = null;
        xmlElement = XmlElementFactory.load(this.loaderAssistFile);
        string = xmlElement.getText("system-identifier");
        languagesStruct = this.loadLanguages(xmlElement.getElement("languages"));
        dataSourceEngine = Constants.DataSourceEngine.get(xmlElement.getText("data-source-engine"));
        string2 = xmlElement.getText("rdbms-naming-scheme");
        loaderAssist = new LoaderAssist(string, languagesStruct, dataSourceEngine, string2);
        this.loadDataSources(xmlElement.getElement("data-sources"), loaderAssist);
        this.loadIgnoreTables(xmlElement.getElement("ignore-tables"), loaderAssist);
        this.loadSystemRoles(xmlElement.getElement("system-roles"), loaderAssist);
        this.loadEntityNameMappings(xmlElement.getElement("entity-name-mappings"), loaderAssist);
        this.loadFieldNameMappings(xmlElement.getElement("field-name-mappings"), loaderAssist);
        this.loadFieldTypeMappings(xmlElement.getElement("field-type-mappings"), loaderAssist);
        this.loadForeignKeyColumns(xmlElement.getElement("foreign-key-columns"), loaderAssist);
        this.loadSystemFields(xmlElement.getElement("system-fields"), loaderAssist);
        this.loadKeys(xmlElement.getElement("keys"), loaderAssist);
        relationshipElement = xmlElement.getElement("relationships");
        return loaderAssist;
    }

    private LoaderAssist.LanguagesStruct loadLanguages(XmlElement xmlElement) throws Exception {
        LoaderAssist.LanguagesStruct languagesStruct = null;
        LanguagesNodeLoader languagesNodeLoader = null;
        languagesNodeLoader = new LanguagesNodeLoader(xmlElement);
        languagesNodeLoader.execute();
        languagesStruct = new LoaderAssist.LanguagesStruct();
        languagesStruct.defaultLanguageCode = languagesNodeLoader.getDefaultLanguageCode();
        languagesStruct.defaultLanguageVariationCode = languagesNodeLoader.getDefaultLanguageVariationCode();
        languagesStruct.languages = languagesNodeLoader.getLanguages();
        return languagesStruct;
    }

    private void loadDataSources(XmlElement xmlElement, LoaderAssist loaderAssist) throws Exception {
        loaderAssist.setDataSources(new DataSourcesNodeLoader(xmlElement).execute());
    }

    private void loadIgnoreTables(XmlElement xmlElement, LoaderAssist loaderAssist) throws Exception {
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("table-name")) {
            loaderAssist.addIgnoreTable(xmlElement2.getText());
        }
    }

    private void loadSystemRoles(XmlElement xmlElement, LoaderAssist loaderAssist) throws Exception {
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("system-role")) {
            this.loadSystemRole(xmlElement2, loaderAssist);
        }
    }

    private void loadSystemRole(XmlElement xmlElement, LoaderAssist loaderAssist) throws Exception {
        SystemRole systemRole = null;
        systemRole = new SystemRole(xmlElement.getLong("id"), xmlElement.getText("name"));
        loaderAssist.addSystemRole(systemRole);
    }

    private void loadEntityNameMappings(XmlElement xmlElement, LoaderAssist loaderAssist) throws Exception {
        LoaderAssist.EntityNameMapping entityNameMapping = null;
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("mapping")) {
            entityNameMapping = new LoaderAssist.EntityNameMapping();
            entityNameMapping.entityName = xmlElement2.getText("entity-name");
            entityNameMapping.tableName = xmlElement2.getText("table-name");
            loaderAssist.addEntityNameMapping(entityNameMapping);
        }
    }

    private void loadFieldNameMappings(XmlElement xmlElement, LoaderAssist loaderAssist) throws Exception {
        LoaderAssist.FieldNameMapping fieldNameMapping = null;
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("mapping")) {
            fieldNameMapping = new LoaderAssist.FieldNameMapping();
            fieldNameMapping.entityName = xmlElement2.getText("entity-name");
            fieldNameMapping.fieldName = xmlElement2.getText("field-name");
            fieldNameMapping.columnName = xmlElement2.getText("column-name");
            loaderAssist.addFieldNameMapping(fieldNameMapping);
        }
    }

    private void loadFieldTypeMappings(XmlElement xmlElement, LoaderAssist loaderAssist) throws Exception {
        LoaderAssist.FieldTypeMapping fieldTypeMapping = null;
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("mapping")) {
            fieldTypeMapping = new LoaderAssist.FieldTypeMapping();
            fieldTypeMapping.entityName = xmlElement2.getText("entity-name");
            fieldTypeMapping.fieldName = xmlElement2.getText("field-name");
            fieldTypeMapping.dataType = xmlElement2.getText("data-type");
            fieldTypeMapping.codeType = xmlElement2.getOptionalText("code-type");
            loaderAssist.addFieldTypeMapping(fieldTypeMapping);
        }
    }

    private void loadForeignKeyColumns(XmlElement xmlElement, LoaderAssist loaderAssist) throws Exception {
        LoaderAssist.ForeignKeyColumn foreignKeyColumn = null;
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("foreign-key-column")) {
            foreignKeyColumn = new LoaderAssist.ForeignKeyColumn();
            foreignKeyColumn.tableName = xmlElement2.getText("table-name");
            foreignKeyColumn.columnName = xmlElement2.getText("column-name");
            loaderAssist.addForeignKeyColumn(foreignKeyColumn);
        }
    }

    private void loadSystemFields(XmlElement xmlElement, LoaderAssist loaderAssist) throws Exception {
        LoaderAssist.SystemFieldsConfig systemFieldsConfig = null;
        systemFieldsConfig = new LoaderAssist.SystemFieldsConfig(xmlElement.getBoolean("look-for-standard"));
        loaderAssist.setSystemFieldsConfig(systemFieldsConfig);
    }

    private void loadKeys(XmlElement xmlElement, LoaderAssist loaderAssist) throws Exception {
        String string = null;
        String string2 = null;
        LoaderAssist.KeyDetails keyDetails = null;
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("key")) {
            string = xmlElement2.getText("entity-name");
            string2 = xmlElement2.getText("name");
            keyDetails = new LoaderAssist.KeyDetails(string, string2);
            loaderAssist.addKey(keyDetails);
            this.loadKeyFields(xmlElement2, keyDetails);
        }
    }

    private void loadKeyFields(XmlElement xmlElement, LoaderAssist.KeyDetails keyDetails) throws Exception {
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("fields")) {
            keyDetails.addFieldName(xmlElement2.getText("field-name"));
        }
    }
}

