/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration.loader.legacy;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.DataSource;
import com.jronimo.systemconfiguration.Language;
import com.jronimo.systemconfiguration.SystemRole;
import com.jronimo.util.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoaderAssist {
    private static final Logger logger = Logger.getLogger(LoaderAssist.class);
    private String systemIdentifier;
    private LanguagesStruct languagesStruct;
    private Constants.DataSourceEngine dataSourceEngine;
    private String rdbmsNamingScheme;
    private Collection<DataSource> dataSources = new ArrayList<DataSource>(1);
    private Collection<String> ignoreTables = new ArrayList<String>();
    private Collection<SystemRole> systemRoles = new ArrayList<SystemRole>();
    private Map<String, EntityNameMapping> entityNameMappings = CollectionUtils.getOrderedMap(new HashMap());
    private Map<String, FieldNameMapping> fieldNameMappings = CollectionUtils.getOrderedMap(new HashMap());
    private Map<String, FieldTypeMapping> fieldTypeMappings = CollectionUtils.getOrderedMap(new HashMap());
    private Collection<ForeignKeyColumn> foreignKeyColumns = new ArrayList<ForeignKeyColumn>(5);
    private SystemFieldsConfig systemFieldsConfig;
    private Collection<KeyDetails> keys = new ArrayList<KeyDetails>();

    public LoaderAssist(String string, LanguagesStruct languagesStruct, Constants.DataSourceEngine dataSourceEngine, String string2) {
        this.systemIdentifier = string;
        this.languagesStruct = languagesStruct;
        this.dataSourceEngine = dataSourceEngine;
        this.rdbmsNamingScheme = string2;
    }

    public String getSystemIdentifier() {
        return this.systemIdentifier;
    }

    public LanguagesStruct getLanguagesStruct() {
        return this.languagesStruct;
    }

    public Constants.DataSourceEngine getDataSourceEngine() {
        return this.dataSourceEngine;
    }

    public String getRdbmsNamingScheme() {
        return this.rdbmsNamingScheme;
    }

    public void setDataSources(Collection<DataSource> collection) {
        this.dataSources = collection;
    }

    public void addDataSource(DataSource dataSource) {
        this.dataSources.add(dataSource);
    }

    public Collection<DataSource> getDataSources() {
        return this.dataSources;
    }

    public void addIgnoreTable(String string) {
        this.ignoreTables.add(string);
    }

    public boolean isIgnoreTable(String string) {
        return this.ignoreTables.contains(string);
    }

    public Collection<String> getIgnoreTables() {
        return this.ignoreTables;
    }

    public void addSystemRole(SystemRole systemRole) {
        this.systemRoles.add(systemRole);
    }

    public Collection<SystemRole> getSystemRoles() {
        return this.systemRoles;
    }

    public void addEntityNameMapping(EntityNameMapping entityNameMapping) {
        this.entityNameMappings.put(entityNameMapping.tableName, entityNameMapping);
    }

    public boolean hasEntityNameMapping(String string) {
        return this.entityNameMappings.containsKey(string);
    }

    public String getEntityNameMapping(String string) {
        String string2 = null;
        if (this.entityNameMappings.keySet().contains(string)) {
            string2 = this.entityNameMappings.get((Object)string).entityName;
        }
        return string2;
    }

    public void addFieldNameMapping(FieldNameMapping fieldNameMapping) {
        this.fieldNameMappings.put(fieldNameMapping.entityName + "." + fieldNameMapping.columnName, fieldNameMapping);
    }

    public boolean hasFieldNameMapping(String string, String string2) {
        return this.fieldNameMappings.containsKey(string + "." + string2);
    }

    public String getFieldNameMapping(String string, String string2) {
        String string3 = null;
        String string4 = null;
        string4 = string + "." + string2;
        if (this.fieldNameMappings.keySet().contains(string4)) {
            string3 = this.fieldNameMappings.get((Object)string4).fieldName;
        }
        return string3;
    }

    public void addFieldTypeMapping(FieldTypeMapping fieldTypeMapping) {
        this.fieldTypeMappings.put(fieldTypeMapping.entityName + "." + fieldTypeMapping.fieldName, fieldTypeMapping);
    }

    public boolean hasFieldTypeMapping(String string, String string2) {
        return this.fieldTypeMappings.containsKey(string + "." + string2);
    }

    public FieldTypeMapping getFieldTypeMapping(String string, String string2) {
        FieldTypeMapping fieldTypeMapping = null;
        String string3 = null;
        string3 = string + "." + string2;
        if (this.fieldTypeMappings.keySet().contains(string3)) {
            fieldTypeMapping = this.fieldTypeMappings.get(string3);
        }
        return fieldTypeMapping;
    }

    public void addForeignKeyColumn(ForeignKeyColumn foreignKeyColumn) {
        this.foreignKeyColumns.add(foreignKeyColumn);
    }

    public boolean isForeignKeyColumn(String string, String string2) {
        boolean bl = false;
        for (ForeignKeyColumn foreignKeyColumn : this.foreignKeyColumns) {
            if (!foreignKeyColumn.tableName.equals(string) || !foreignKeyColumn.columnName.equals(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void setSystemFieldsConfig(SystemFieldsConfig systemFieldsConfig) {
        this.systemFieldsConfig = systemFieldsConfig;
    }

    public SystemFieldsConfig getSystemFieldsConfig() {
        return this.systemFieldsConfig;
    }

    public void addKey(KeyDetails keyDetails) {
        this.keys.add(keyDetails);
    }

    public Collection<KeyDetails> getKeys(String string) {
        Set set = null;
        set = CollectionUtils.getOrderedSet();
        for (KeyDetails keyDetails : this.keys) {
            if (!keyDetails.getEntityName().equals(string)) continue;
            set.add(keyDetails);
        }
        return set;
    }

    public static final class LanguagesStruct {
        public String defaultLanguageCode;
        public String defaultLanguageVariationCode;
        public Collection<Language> languages;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyDetails {
        private String entityName;
        private String keyName;
        private Collection<String> fieldNames = CollectionUtils.getOrderedSet(new HashSet(5));

        public KeyDetails(String string, String string2) {
            this.entityName = string;
            this.keyName = string2;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public void addFieldName(String string) {
            this.fieldNames.add(string);
        }

        public Collection<String> getFieldNames() {
            return this.fieldNames;
        }
    }

    public static class SystemFieldsConfig {
        private boolean lookForStandard;

        public SystemFieldsConfig(boolean bl) {
            this.lookForStandard = bl;
        }

        public boolean lookForStandard() {
            return this.lookForStandard;
        }
    }

    public static class ForeignKeyColumn {
        public String tableName;
        public String columnName;
    }

    public static class FieldTypeMapping {
        public String entityName;
        public String fieldName;
        public String dataType;
        public String codeType;
    }

    public static class FieldNameMapping {
        public String entityName;
        public String fieldName;
        public String columnName;
    }

    public static class EntityNameMapping {
        public String entityName;
        public String tableName;
    }
}

