/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.DataType;
import com.jronimo.systemconfiguration.DatabaseType;
import com.jronimo.systemconfiguration.MySqlType;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SystemFieldType {
    private static final Logger logger = Logger.getLogger(SystemFieldType.class);
    public static final String NAME_SYSTEM_MANAGED_ID = "SystemManagedId";
    public static final String NAME_RECORD_STATUS = "RecordStatus";
    public static final String NAME_RECORD_VERSION_WHOLE_NUMBER = "RecordVersion_WholeNumber";
    public static final String NAME_RECORD_VERSION_TIMESTAMP = "RecordVersion_Timestamp";
    public static final String NAME_RECORD_VERSION_DATE_TIME = "RecordVersion_DateTime";
    public static final String NAME_AUDIT_CREATE_USER_ID = "AuditCreateUserId";
    public static final String NAME_AUDIT_CREATE_USERNAME = "AuditCreateUsername";
    public static final String NAME_AUDIT_CREATE_TIMESTAMP = "AuditCreateTimestamp";
    public static final String NAME_AUDIT_UPDATE_USER_ID = "AuditUpdateUserId";
    public static final String NAME_AUDIT_UPDATE_USERNAME = "AuditUpdateUsername";
    public static final String NAME_AUDIT_UPDATE_TIMESTAMP = "AuditUpdateTimestamp";
    protected static Map<String, SystemFieldType> types;
    private String identifier;
    private String defaultFieldName;
    private String defaultPersistenceName;
    private Map<Constants.DataSourceEngine, Map<String, TypeDetails>> typeDetails;
    private Map<Constants.DataSourceEngine, TypeDetails> defaultTypes;

    private SystemFieldType(String string, String string2, String string3, Map<Constants.DataSourceEngine, Map<String, TypeDetails>> map, Map<Constants.DataSourceEngine, TypeDetails> map2) {
        this.identifier = string;
        this.defaultFieldName = string2;
        this.defaultPersistenceName = string3;
        this.typeDetails = map;
        this.defaultTypes = map2;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDefaultFieldName() {
        return this.defaultFieldName;
    }

    public String getDefaultPersistenceName() {
        return this.defaultPersistenceName;
    }

    public TypeDetails getType(Constants.DataSourceEngine dataSourceEngine, String string) {
        return this.typeDetails.get((Object)dataSourceEngine).get(string);
    }

    public DatabaseType getDatabaseType(Constants.DataSourceEngine dataSourceEngine, String string) {
        return this.typeDetails.get((Object)dataSourceEngine).get(string).getDatabaseType();
    }

    public DataType getDataType(Constants.DataSourceEngine dataSourceEngine, String string) {
        return this.typeDetails.get((Object)dataSourceEngine).get(string).getDataType();
    }

    public Constants.CodeType getCodeType(Constants.DataSourceEngine dataSourceEngine, String string) {
        return this.typeDetails.get((Object)dataSourceEngine).get(string).getCodeType();
    }

    public TypeDetails getDefaultType(Constants.DataSourceEngine dataSourceEngine) {
        return this.defaultTypes.get((Object)dataSourceEngine);
    }

    public boolean isRecordStatus() {
        return this.identifier.equals(NAME_RECORD_STATUS);
    }

    public boolean isRecordVersion() {
        return this.identifier.startsWith("RecordVersion");
    }

    public boolean isRecordVersionWholeNumber() {
        return this.identifier.equals(NAME_RECORD_VERSION_WHOLE_NUMBER);
    }

    public boolean isRecordVersionTimestamp() {
        return this.identifier.equals(NAME_RECORD_VERSION_TIMESTAMP);
    }

    public boolean isRecordVersionDateTime() {
        return this.identifier.equals(NAME_RECORD_VERSION_DATE_TIME);
    }

    public boolean isAuditCreateUser() {
        return this.identifier.startsWith("AuditCreateUser");
    }

    public boolean isAuditCreateUserId() {
        return this.identifier.equals(NAME_AUDIT_CREATE_USER_ID);
    }

    public boolean isAuditCreateUsername() {
        return this.identifier.equals(NAME_AUDIT_CREATE_USERNAME);
    }

    public boolean isAuditCreateTimestamp() {
        return this.identifier.equals(NAME_AUDIT_CREATE_TIMESTAMP);
    }

    public boolean isAuditUpdateUser() {
        return this.identifier.startsWith("AuditUpdateUser");
    }

    public boolean isAuditUpdateUserId() {
        return this.identifier.equals(NAME_AUDIT_UPDATE_USER_ID);
    }

    public boolean isAuditUpdateUsername() {
        return this.identifier.equals(NAME_AUDIT_UPDATE_USERNAME);
    }

    public boolean isAuditUpdateTimestamp() {
        return this.identifier.equals(NAME_AUDIT_UPDATE_TIMESTAMP);
    }

    public static SystemFieldType find(String string) {
        return types.get(string);
    }

    private static void load() {
        Map map = null;
        XmlElement xmlElement = null;
        SystemFieldType systemFieldType = null;
        try {
            map = CollectionUtils.getOrderedMap(new HashMap(10));
            xmlElement = XmlElementFactory.load(Methods.getClassPathResourceAsStream(SystemFieldType.class, "SystemFieldTypes.xml"));
            for (XmlElement xmlElement2 : xmlElement.getOptionalElements("system-field-type")) {
                systemFieldType = SystemFieldType.loadType(xmlElement2);
                map.put(systemFieldType.getIdentifier(), systemFieldType);
            }
            types = map;
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
    }

    private static SystemFieldType loadType(XmlElement xmlElement) {
        SystemFieldType systemFieldType = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        Map map = null;
        Map map2 = null;
        Map map3 = null;
        TypeDetails typeDetails = null;
        Constants.DataSourceEngine dataSourceEngine = null;
        string = xmlElement.getText("identifier");
        string2 = xmlElement.getText("default-field-name");
        string3 = xmlElement.getText("default-persistence-name");
        map = CollectionUtils.getOrderedMap(new HashMap(3));
        map2 = CollectionUtils.getOrderedMap(new HashMap(4));
        for (XmlElement xmlElement2 : xmlElement.getOptionalElements("data-source-types")) {
            map3 = CollectionUtils.getOrderedMap(new HashMap(4));
            dataSourceEngine = Constants.DataSourceEngine.get(xmlElement2.getText("engine"));
            for (XmlElement xmlElement3 : xmlElement2.getOptionalElements("type")) {
                typeDetails = new TypeDetails(dataSourceEngine, xmlElement3.getText("data-source-type"), xmlElement3.getText("data-type"), xmlElement3.getText("code-type"));
                map3.put(typeDetails.databaseType.getName(), typeDetails);
            }
            map.put(dataSourceEngine, map3);
            map2.put(dataSourceEngine, map3.get(xmlElement2.getText("default-type")));
        }
        systemFieldType = new SystemFieldType(string, string2, string3, map, map2);
        return systemFieldType;
    }

    static {
        SystemFieldType.load();
    }

    public static class TypeDetails {
        private DatabaseType databaseType;
        private DataType dataType;
        private Constants.CodeType codeType;

        TypeDetails(Constants.DataSourceEngine dataSourceEngine, String string, String string2, String string3) {
            if (dataSourceEngine == Constants.DataSourceEngine.MY_SQL) {
                this.databaseType = MySqlType.find(string);
            }
            this.dataType = DataType.getDataType(string2);
            this.codeType = Constants.CodeType.get(string3);
        }

        public DatabaseType getDatabaseType() {
            return this.databaseType;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public Constants.CodeType getCodeType() {
            return this.codeType;
        }
    }
}

