/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration;

import com.jronimo.systemconfiguration.DataSource;
import com.jronimo.systemconfiguration.Entity;
import com.jronimo.systemconfiguration.EntityPermissionSecurityClause;
import com.jronimo.systemconfiguration.Language;
import com.jronimo.systemconfiguration.Repository;
import com.jronimo.systemconfiguration.SystemRole;
import com.jronimo.util.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemConfiguration {
    private static final Logger logger = Logger.getLogger(SystemConfiguration.class);
    private static final SystemRole SYSTEM_ROLE_ANYONE = new SystemRole(0L, "Anyone");
    private static final SystemRole SYSTEM_ROLE_AUTHENTICATED_USER = new SystemRole(0L, "AuthenticatedUser");
    private String identifier;
    private String defaultLanguageCode;
    private String defaultLanguageVariationCode;
    private Collection<Language> languages;
    private Collection<SystemRole> systemRoles = new ArrayList<SystemRole>(10);
    private Map<Long, SystemRole> indexSystemRoleIds = new HashMap<Long, SystemRole>(10);
    private Map<String, SystemRole> indexSystemRoleNames = new HashMap<String, SystemRole>(10);
    private Repository repository;
    private Map<String, Set<String>> systemRoleEntities = new HashMap<String, Set<String>>();
    private Map<String, Map<String, Set<String>>> systemRoleEntityOperations = new HashMap<String, Map<String, Set<String>>>();
    private Map<String, Map<String, Set<String>>> systemRoleEntityReadFields = new HashMap<String, Map<String, Set<String>>>();
    private Map<String, Map<String, Set<String>>> systemRoleEntityWriteFields = new HashMap<String, Map<String, Set<String>>>();
    private Map<String, Set<String>> systemRoleBusinessObjects = new HashMap<String, Set<String>>();
    private Map<String, Map<String, Set<String>>> systemRoleBusinessObjectOperations = new HashMap<String, Map<String, Set<String>>>();
    private final Map<Long, EntityPermissionSecurityClause> indexEntityPermissionSecurityClauses = new HashMap<Long, EntityPermissionSecurityClause>(100);

    public SystemConfiguration(String string, String string2, String string3) {
        this.identifier = string;
        this.defaultLanguageCode = string2;
        this.defaultLanguageVariationCode = string3;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    public String getDefaultLanguageVariationCode() {
        return this.defaultLanguageVariationCode;
    }

    public void setLanguages(Collection<Language> collection) {
        this.languages = collection;
    }

    public Collection<Language> getLanguages() {
        return this.languages;
    }

    public synchronized void setSystemRoles(Collection<SystemRole> collection) {
        this.systemRoles = collection;
        this.indexSystemRoleIds.clear();
        this.indexSystemRoleNames.clear();
        for (SystemRole systemRole : collection) {
            this.indexSystemRoleIds.put(systemRole.getId(), systemRole);
            this.indexSystemRoleNames.put(systemRole.getName(), systemRole);
        }
    }

    public void addSystemRole(SystemRole systemRole) {
        if (!this.systemRoles.contains(systemRole)) {
            this.systemRoles.add(systemRole);
        }
        if (!this.indexSystemRoleIds.containsKey(systemRole.getId())) {
            this.indexSystemRoleIds.put(systemRole.getId(), systemRole);
        }
        if (!this.indexSystemRoleNames.containsKey(systemRole.getId())) {
            this.indexSystemRoleNames.put(systemRole.getName(), systemRole);
        }
    }

    public Collection<SystemRole> getSystemRoles() {
        return this.systemRoles;
    }

    public boolean hasSystemRole(long l) {
        return this.getSystemRole(l) != null;
    }

    public boolean hasSystemRole(String string) {
        return this.getSystemRole(string) != null;
    }

    public SystemRole getSystemRole(long l) {
        SystemRole systemRole = null;
        systemRole = l == 0L ? SYSTEM_ROLE_ANYONE : (l == 1L ? SYSTEM_ROLE_AUTHENTICATED_USER : this.indexSystemRoleIds.get(l));
        return systemRole;
    }

    public SystemRole getSystemRole(String string) {
        SystemRole systemRole = null;
        systemRole = string.equals("Anyone") ? SYSTEM_ROLE_ANYONE : (string.equals("AuthenticatedUser") ? SYSTEM_ROLE_AUTHENTICATED_USER : this.indexSystemRoleNames.get(string));
        return systemRole;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public DataSource getDefaultDataSource() {
        DataSource dataSource = null;
        for (DataSource dataSource2 : this.repository.getDataSources()) {
            if (!dataSource2.isDefault()) continue;
            dataSource = dataSource2;
            break;
        }
        return dataSource;
    }

    public DataSource getDataSource(String string) {
        DataSource dataSource = null;
        for (DataSource dataSource2 : this.repository.getDataSources()) {
            if (!dataSource2.getName().equals(string)) continue;
            dataSource = dataSource2;
            break;
        }
        return dataSource;
    }

    public String getEntitySchema(Entity entity) {
        String string = null;
        boolean bl = true;
        if (entity.getDataSource() == null) {
            bl = true;
        } else if (entity.getDataSource().schema == null) {
            bl = true;
        }
        string = bl ? this.getDefaultDataSource().getDefaultSchema() : entity.getDataSource().schema;
        return string;
    }

    public Entity getEntity(String string) {
        Entity entity = null;
        entity = this.repository.getEntity(string);
        return entity;
    }

    public void addEntityPermissionSecurityClause(EntityPermissionSecurityClause entityPermissionSecurityClause) {
        this.indexEntityPermissionSecurityClauses.put(entityPermissionSecurityClause.getId(), entityPermissionSecurityClause);
    }

    public EntityPermissionSecurityClause getEntityPermissionSecurityClause(long l) {
        return this.indexEntityPermissionSecurityClauses.get(l);
    }

    public boolean hasBusinessObjectAccess(Collection<String> collection, String string) {
        boolean bl = false;
        Set<String> set = null;
        for (String string2 : collection) {
            set = this.systemRoleBusinessObjects.get(string2);
            if (set == null || !set.contains(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean hasBusinessObjectOperationAccess(Collection<String> collection, String string, String string2) {
        boolean bl = false;
        Map<String, Set<String>> map = null;
        Set<String> set = null;
        for (String string3 : collection) {
            map = this.systemRoleBusinessObjectOperations.get(string3);
            if (map == null || (set = map.get(string)) == null || !set.contains(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

