/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.systemconfiguration.EntityPermission;
import com.jronimo.systemconfiguration.EntityPermissionSecurityClause;
import com.jronimo.systemconfiguration.Permission;
import com.jronimo.systemconfiguration.SystemConfiguration;
import com.jronimo.systemconfiguration.SystemRole;
import com.jronimo.util.Logger;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityConfiguration {
    private static final Logger logger = Logger.getLogger(SecurityConfiguration.class);
    private List<Permission> permissions = new ArrayList<Permission>(5);

    public void addPermission(Permission permission, SystemConfiguration systemConfiguration) {
        this.permissions.add(permission);
        for (SystemRole systemRole : permission.getSystemRoles()) {
            for (EntityPermission entityPermission : permission.getEntityPermissions()) {
                for (EntityPermissionSecurityClause entityPermissionSecurityClause : entityPermission.getSecurityClauses()) {
                    systemRole.addSecurityClause(entityPermission.getEntityName(), entityPermissionSecurityClause);
                    systemConfiguration.addEntityPermissionSecurityClause(entityPermissionSecurityClause);
                }
            }
        }
    }

    public List<Permission> getPermissions() {
        return CollectionUtils.collectionToList(this.permissions);
    }
}

