/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.systemconfiguration.EntityPermissionSecurityClause;
import com.jronimo.util.Logger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityClauseSet {
    private static final Logger logger = Logger.getLogger(SecurityClauseSet.class);
    private Set<EntityPermissionSecurityClause> clauses = CollectionUtils.getOrderedSet(new HashSet(2));

    public SecurityClauseSet() {
    }

    public SecurityClauseSet(List<SecurityClauseSet> list) {
        for (SecurityClauseSet securityClauseSet : list) {
            for (EntityPermissionSecurityClause entityPermissionSecurityClause : securityClauseSet.getSecurityClauses()) {
                this.clauses.add(entityPermissionSecurityClause);
            }
        }
    }

    public SecurityClauseSet(SecurityClauseSet[] securityClauseSetArray) {
        for (SecurityClauseSet securityClauseSet : securityClauseSetArray) {
            for (EntityPermissionSecurityClause entityPermissionSecurityClause : securityClauseSet.getSecurityClauses()) {
                this.clauses.add(entityPermissionSecurityClause);
            }
        }
    }

    public void add(SecurityClauseSet securityClauseSet) {
        for (EntityPermissionSecurityClause entityPermissionSecurityClause : securityClauseSet.getSecurityClauses()) {
            this.clauses.add(entityPermissionSecurityClause);
        }
    }

    public void add(EntityPermissionSecurityClause entityPermissionSecurityClause) {
        this.clauses.add(entityPermissionSecurityClause);
    }

    public Set<EntityPermissionSecurityClause> getSecurityClauses() {
        return this.clauses;
    }

    public Set<Long> getSecurityClauseIds() {
        Set set = null;
        set = CollectionUtils.getOrderedSet(new HashSet(this.clauses.size()));
        for (EntityPermissionSecurityClause entityPermissionSecurityClause : this.clauses) {
            set.add(entityPermissionSecurityClause.getId());
        }
        return set;
    }

    public Long getId() {
        Long l;
        block0: {
            l = null;
            Iterator<EntityPermissionSecurityClause> iterator = this.clauses.iterator();
            if (!iterator.hasNext()) break block0;
            EntityPermissionSecurityClause entityPermissionSecurityClause = iterator.next();
            l = entityPermissionSecurityClause.getId();
        }
        return l;
    }

    public boolean isEmpty() {
        return this.clauses.isEmpty();
    }

    public int size() {
        return this.clauses.size();
    }

    public boolean hasDefault() {
        boolean bl = false;
        int n = 0;
        for (EntityPermissionSecurityClause entityPermissionSecurityClause : this.clauses) {
            if (!entityPermissionSecurityClause.isDefault()) continue;
            ++n;
        }
        bl = n == 1;
        return bl;
    }

    public boolean hasDefaultOnly() {
        boolean bl = false;
        bl = this.hasDefault() && this.clauses.size() == 1;
        return bl;
    }

    public boolean hasReadField(String string) {
        boolean bl = false;
        for (EntityPermissionSecurityClause entityPermissionSecurityClause : this.clauses) {
            if (!entityPermissionSecurityClause.hasReadField(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean hasUpdateField(String string) {
        boolean bl = false;
        for (EntityPermissionSecurityClause entityPermissionSecurityClause : this.clauses) {
            if (!entityPermissionSecurityClause.hasUpdateField(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean hasCreateField(String string) {
        boolean bl = false;
        for (EntityPermissionSecurityClause entityPermissionSecurityClause : this.clauses) {
            if (!entityPermissionSecurityClause.hasCreateField(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void eliminateBasedOnReadField(String string) {
        for (EntityPermissionSecurityClause entityPermissionSecurityClause : this.clauses) {
            if (entityPermissionSecurityClause.hasReadField(string)) continue;
            this.clauses.remove(entityPermissionSecurityClause);
        }
    }

    public void eliminateBasedOnUpdateField(String string) {
        for (EntityPermissionSecurityClause entityPermissionSecurityClause : this.clauses) {
            if (entityPermissionSecurityClause.hasUpdateField(string)) continue;
            this.clauses.remove(entityPermissionSecurityClause);
        }
    }

    public void eliminateBasedOnCreateField(String string) {
        for (EntityPermissionSecurityClause entityPermissionSecurityClause : this.clauses) {
            if (entityPermissionSecurityClause.hasCreateField(string)) continue;
            this.clauses.remove(entityPermissionSecurityClause);
        }
    }
}

