/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration;

import com.jronimo.engines.dataservice.SecurityClause;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.util.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityPermissionSecurityClause
implements SecurityClause {
    private static final Logger logger = Logger.getLogger(EntityPermissionSecurityClause.class);
    private Long id;
    private String clause;
    private boolean isDefault;
    private List<Constants.EntityOperation> supportedOperations = new ArrayList<Constants.EntityOperation>(5);
    private List<String> readFields = new ArrayList<String>();
    private List<String> updateFields = new ArrayList<String>();
    private List<String> createFields = new ArrayList<String>();

    public EntityPermissionSecurityClause(Long l, String string) {
        this.id = l;
        this.clause = string;
        this.isDefault = string.equals("default");
    }

    public Long getId() {
        return this.id;
    }

    @Override
    public String getClause() {
        return this.clause;
    }

    @Override
    public Set<String> getSecurityProperties() {
        HashSet<String> hashSet = null;
        int n = 0;
        int n2 = 0;
        String string = null;
        hashSet = new HashSet<String>(2);
        while ((n = this.clause.indexOf("{", n)) >= 0) {
            if (hashSet.contains(string = this.clause.substring(++n, n2 = this.clause.indexOf("}", n)))) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public void addSupportedOperation(Constants.EntityOperation entityOperation) {
        this.supportedOperations.add(entityOperation);
    }

    public List<Constants.EntityOperation> getSupportedOperations() {
        return this.supportedOperations;
    }

    public boolean supportsList() {
        return this.supportedOperations.contains((Object)Constants.EntityOperation.LIST);
    }

    public boolean supportsGet() {
        return this.supportedOperations.contains((Object)Constants.EntityOperation.GET);
    }

    public boolean supportsCreate() {
        return this.supportedOperations.contains((Object)Constants.EntityOperation.CREATE);
    }

    public boolean supportsUpdate() {
        return this.supportedOperations.contains((Object)Constants.EntityOperation.UPDATE);
    }

    public boolean supportsDelete() {
        return this.supportedOperations.contains((Object)Constants.EntityOperation.DELETE);
    }

    public void addReadField(String string) {
        this.readFields.add(string);
    }

    public List<String> getReadFields() {
        return this.readFields;
    }

    public boolean hasReadField(String string) {
        return this.readFields.contains(string);
    }

    public void addUpdateField(String string) {
        this.updateFields.add(string);
    }

    public List<String> getUpdateFields() {
        return this.updateFields;
    }

    public boolean hasUpdateField(String string) {
        return this.updateFields.contains(string);
    }

    public void addCreateField(String string) {
        this.createFields.add(string);
    }

    public List<String> getCreateFields() {
        return this.createFields;
    }

    public boolean hasCreateField(String string) {
        return this.createFields.contains(string);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        EntityPermissionSecurityClause entityPermissionSecurityClause = null;
        if (object instanceof EntityPermissionSecurityClause) {
            entityPermissionSecurityClause = (EntityPermissionSecurityClause)object;
            if (entityPermissionSecurityClause.id == this.id) {
                bl = true;
            }
        }
        return bl;
    }
}

