/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration;

import com.jronimo.collections.NullFreeMutableSet;
import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.collections.collection.decorations.NullFreeImmutableSet_U;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.DataType;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import com.jronimo.xml.XmlUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataTypesLoader {
    private static final Logger logger = Logger.getLogger(DataTypesLoader.class);

    DataTypesLoader() {
    }

    Map<String, DataType> load() {
        Map map = null;
        XmlElement xmlElement = null;
        DataType dataType = null;
        try {
            map = CollectionUtils.getOrderedMap(new HashMap(27));
            xmlElement = XmlElementFactory.load(Methods.getClassPathResourceAsStream(DataTypesLoader.class, "DataTypes.xml"));
            for (XmlElement xmlElement2 : xmlElement.getOptionalElements("data-type")) {
                dataType = this.loadDataType(xmlElement2);
                map.put(dataType.getName(), dataType);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new UnexpectedErrorException(exception);
        }
        return map;
    }

    private DataType loadDataType(XmlElement xmlElement) throws Exception {
        DataType dataType = null;
        String string = null;
        String string2 = null;
        DataType.BroadType broadType = null;
        DataType.CodeTypes codeTypes = null;
        Map<Constants.DataSourceEngine, DataType.DataSourceEngineType> map = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        com.jronimo.collections.collection.types.Collection<DataType.Parameter> collection = null;
        string = xmlElement.getText("name");
        string2 = xmlElement.getText("comments");
        broadType = DataType.BroadType.get(xmlElement.getText("broad-type"));
        codeTypes = this.getCodeTypes(xmlElement.getElement("code-types"));
        map = this.getDatabaseEngineTypes(xmlElement.getOptionalElements("database-engine"));
        bl = xmlElement.getOptionalBoolean("supports-capacity", "false");
        bl2 = xmlElement.getOptionalBoolean("supports-precision-and-scale", "false");
        bl3 = xmlElement.getOptionalBoolean("supports-character-set", "false");
        bl4 = xmlElement.getOptionalBoolean("supports-collation", "false");
        collection = this.getParameters(xmlElement.getOptionalElements("parameters/parameter"));
        dataType = new DataType(string, string2, broadType, codeTypes, map, bl, bl2, bl3, bl4, collection);
        return dataType;
    }

    private DataType.CodeTypes getCodeTypes(XmlElement xmlElement) throws Exception {
        DataType.CodeTypes codeTypes = null;
        codeTypes = new DataType.CodeTypes();
        codeTypes.types = new NullFreeImmutableSet_U<String>((Collection<String>)XmlUtils.getTextFromElements(xmlElement.getElements("type", 1)));
        codeTypes.defaultType = xmlElement.getText("default-type");
        return codeTypes;
    }

    private Map<Constants.DataSourceEngine, DataType.DataSourceEngineType> getDatabaseEngineTypes(com.jronimo.collections.collection.types.Collection<XmlElement> collection) throws Exception {
        Map map = null;
        DataType.DataSourceEngineType dataSourceEngineType = null;
        map = CollectionUtils.getOrderedMap(new HashMap(collection.size()));
        for (XmlElement xmlElement : collection) {
            dataSourceEngineType = new DataType.DataSourceEngineType();
            dataSourceEngineType.dataSourceEngine = Constants.DataSourceEngine.get(xmlElement.getText("name"));
            dataSourceEngineType.types = new NullFreeImmutableSet_U<String>((Collection<String>)XmlUtils.getTextFromElements(xmlElement.getElements("types/type", 1)));
            dataSourceEngineType.defaultType = xmlElement.getText("default-type");
            map.put(dataSourceEngineType.dataSourceEngine, dataSourceEngineType);
        }
        return map;
    }

    private com.jronimo.collections.collection.types.Collection<DataType.Parameter> getParameters(com.jronimo.collections.collection.types.Collection<XmlElement> collection) throws Exception {
        NullFreeMutableSet<DataType.Parameter> nullFreeMutableSet = null;
        DataType.Parameter parameter = null;
        nullFreeMutableSet = new NullFreeMutableSet<DataType.Parameter>(collection.size());
        for (XmlElement xmlElement : collection) {
            parameter = new DataType.Parameter();
            parameter.name = xmlElement.getText("name");
            parameter.mandatory = xmlElement.getBoolean("mandatory");
            parameter.type = xmlElement.getText("type");
            parameter.defaultValue = xmlElement.getText("default-value");
            parameter.comments = xmlElement.getText("comments");
            if (parameter.type.equals("LOV")) {
                parameter.lov = this.getParameterLov(xmlElement.getOptionalElements("lov/value"));
            }
            nullFreeMutableSet.add(parameter);
        }
        return nullFreeMutableSet;
    }

    private com.jronimo.collections.collection.types.Collection<String> getParameterLov(com.jronimo.collections.collection.types.Collection<XmlElement> collection) throws Exception {
        NullFreeMutableSet<String> nullFreeMutableSet = null;
        nullFreeMutableSet = new NullFreeMutableSet<String>(collection.size());
        for (XmlElement xmlElement : collection) {
            nullFreeMutableSet.add(xmlElement.getText());
        }
        return nullFreeMutableSet;
    }
}

