/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration;

import com.jronimo.collections.collection.decorations.NullFreeImmutableSet_U;
import com.jronimo.systemconfiguration.Constants;
import com.jronimo.systemconfiguration.DataTypesLoader;
import com.jronimo.util.Logger;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataType {
    private static final Logger logger = Logger.getLogger(DataType.class);
    public static final String DATA_SERVICE_ID = "DataServiceId";
    public static final String AUTO_NUMBER = "AutoNumber";
    public static final String FIXED_LENGTH_TEXT = "FixedLengthText";
    public static final String VARIABLE_LENGTH_TEXT = "VariableLengthText";
    public static final String CLOB = "Clob";
    public static final String BLOB = "Blob";
    public static final String WHOLE_NUMBER_1 = "WholeNumber1";
    public static final String WHOLE_NUMBER_2 = "WholeNumber2";
    public static final String WHOLE_NUMBER_4 = "WholeNumber4";
    public static final String WHOLE_NUMBER_8 = "WholeNumber8";
    public static final String DECIMAL_NUMBER_4 = "DecimalNumber4";
    public static final String DECIMAL_NUMBER_8 = "DecimalNumber8";
    public static final String DECIMAL_NUMBER_PS = "DecimalNumberPS";
    public static final String BOOLEAN = "Boolean";
    public static final String TIMEZONE = "Timezone";
    public static final String DATE = "Date";
    public static final String DATE_TIME = "DateTime";
    public static final String TIMESTAMP = "Timestamp";
    public static final String TIME_OF_DAY = "TimeOfDay";
    public static final String TIME = "Time";
    public static final String YEAR = "Year";
    public static final String YEAR_MILLIONS = "YearMillions";
    public static final String YEAR_BILLIONS = "YearBillions";
    public static final String GROUPING_ID = "GroupingId";
    public static final String FOREIGN_KEY_MEMBER = "ForeignKeyMember";
    public static final String REF_DATA = "RefData";
    public static final String TEXT_ELEMENT = "TextElement";
    private static Map<String, DataType> dataTypes;
    private String name;
    private String comments;
    private BroadType broadType;
    private CodeTypes codeTypes;
    private Map<Constants.DataSourceEngine, DataSourceEngineType> dataSourceEngineTypes;
    private boolean supportsCapacity;
    private boolean supportsPrecisionAndScale;
    private boolean supportsCharacterSet;
    private boolean supportsCollation;
    private Collection<Parameter> parameters;

    DataType(String string, String string2, BroadType broadType, CodeTypes codeTypes, Map<Constants.DataSourceEngine, DataSourceEngineType> map, boolean bl, boolean bl2, boolean bl3, boolean bl4, Collection<Parameter> collection) {
        this.name = string;
        this.comments = string2;
        this.broadType = broadType;
        this.codeTypes = codeTypes;
        this.dataSourceEngineTypes = map;
        this.supportsCapacity = bl;
        this.supportsPrecisionAndScale = bl2;
        this.supportsCharacterSet = bl3;
        this.supportsCollation = bl4;
        this.parameters = collection;
    }

    public static synchronized DataType getDataType(String string) {
        DataType dataType = null;
        if (dataTypes == null) {
            dataTypes = new DataTypesLoader().load();
        }
        dataType = dataTypes.get(string);
        return dataType;
    }

    public static DataType getDefaultMySqlDataType(String string) {
        DataType dataType = null;
        if (string.startsWith("CHAR")) {
            dataType = DataType.getDataType(FIXED_LENGTH_TEXT);
        } else if (string.startsWith("VARCHAR")) {
            dataType = DataType.getDataType(VARIABLE_LENGTH_TEXT);
        } else if (string.startsWith("TINYTEXT")) {
            dataType = DataType.getDataType(CLOB);
        } else if (string.startsWith("TEXT")) {
            dataType = DataType.getDataType(CLOB);
        } else if (string.startsWith("MEDIUMTEXT")) {
            dataType = DataType.getDataType(CLOB);
        } else if (string.startsWith("LONGTEXT")) {
            dataType = DataType.getDataType(CLOB);
        } else if (string.startsWith("TINYBLOB")) {
            dataType = DataType.getDataType(BLOB);
        } else if (string.startsWith("BLOB")) {
            dataType = DataType.getDataType(BLOB);
        } else if (string.startsWith("MEDIUMBLOB")) {
            dataType = DataType.getDataType(BLOB);
        } else if (string.startsWith("LONGBLOB")) {
            dataType = DataType.getDataType(BLOB);
        } else if (string.startsWith("TINYINT")) {
            dataType = DataType.getDataType(WHOLE_NUMBER_1);
        } else if (string.startsWith("SMALLINT")) {
            dataType = DataType.getDataType(WHOLE_NUMBER_2);
        } else if (string.startsWith("INT")) {
            dataType = DataType.getDataType(WHOLE_NUMBER_4);
        } else if (string.startsWith("BIGINT")) {
            dataType = DataType.getDataType(WHOLE_NUMBER_8);
        } else if (string.startsWith("FLOAT")) {
            dataType = DataType.getDataType(DECIMAL_NUMBER_4);
        } else if (string.startsWith("DOUBLE")) {
            dataType = DataType.getDataType(DECIMAL_NUMBER_8);
        } else if (string.startsWith("DECIMAL")) {
            dataType = DataType.getDataType(DECIMAL_NUMBER_PS);
        } else if (string.startsWith("NUMERIC")) {
            dataType = DataType.getDataType(DECIMAL_NUMBER_PS);
        } else if (string.startsWith("DATETIME")) {
            dataType = DataType.getDataType(DATE_TIME);
        } else if (string.startsWith("DATE")) {
            dataType = DataType.getDataType(DATE);
        } else if (string.startsWith("TIME")) {
            dataType = DataType.getDataType(TIME_OF_DAY);
        }
        return dataType;
    }

    public String getName() {
        return this.name;
    }

    public String getComments() {
        return this.comments;
    }

    public BroadType getBroadType() {
        return this.broadType;
    }

    public Collection<String> getCodeTypes() {
        return this.codeTypes.types;
    }

    public String getDefaultCodeType() {
        return this.codeTypes.defaultType;
    }

    public Collection<String> getPersistenceTypes(String string) {
        return this.dataSourceEngineTypes.get((Object)string).types;
    }

    public String getDefaultPersistenceType(String string) {
        return this.dataSourceEngineTypes.get((Object)string).defaultType;
    }

    public boolean supportsCapacity() {
        return this.supportsCapacity;
    }

    public boolean supportsPrecisionAndScale() {
        return this.supportsPrecisionAndScale;
    }

    public boolean supportsCharacterSet() {
        return this.supportsCharacterSet;
    }

    public boolean supportsCollation() {
        return this.supportsCollation;
    }

    public Collection<Parameter> getParameters() {
        return this.parameters;
    }

    public boolean isDataServiceId() {
        return this.name.equals(DATA_SERVICE_ID);
    }

    public boolean isAutoNumber() {
        return this.name.equals(AUTO_NUMBER);
    }

    public boolean isFixedLengthText() {
        return this.name.equals(FIXED_LENGTH_TEXT);
    }

    public boolean isVariableLengthText() {
        return this.name.equals(VARIABLE_LENGTH_TEXT);
    }

    public boolean isClob() {
        return this.name.equals(CLOB);
    }

    public boolean isBlob() {
        return this.name.equals(BLOB);
    }

    public boolean isWholeNumber1() {
        return this.name.equals(WHOLE_NUMBER_1);
    }

    public boolean isWholeNumber2() {
        return this.name.equals(WHOLE_NUMBER_2);
    }

    public boolean isWholeNumber4() {
        return this.name.equals(WHOLE_NUMBER_4);
    }

    public boolean isWholeNumber8() {
        return this.name.equals(WHOLE_NUMBER_8);
    }

    public boolean isDecimalNumber4() {
        return this.name.equals(DECIMAL_NUMBER_4);
    }

    public boolean isDecimalNumber8() {
        return this.name.equals(DECIMAL_NUMBER_8);
    }

    public boolean isDecimalNumberPS() {
        return this.name.equals(DECIMAL_NUMBER_PS);
    }

    public boolean isBoolean() {
        return this.name.equals(BOOLEAN);
    }

    public boolean isTimezone() {
        return this.name.equals(TIMEZONE);
    }

    public boolean isDate() {
        return this.name.equals(DATE);
    }

    public boolean isDateTime() {
        return this.name.equals(DATE_TIME);
    }

    public boolean isTimestamp() {
        return this.name.equals(TIMESTAMP);
    }

    public boolean isTimeOfDay() {
        return this.name.equals(TIME_OF_DAY);
    }

    public boolean isTime() {
        return this.name.equals(TIME);
    }

    public boolean isYear() {
        return this.name.equals(YEAR);
    }

    public boolean isYearMillions() {
        return this.name.equals(YEAR_MILLIONS);
    }

    public boolean isYearBillions() {
        return this.name.equals(YEAR_BILLIONS);
    }

    public boolean isGroupingId() {
        return this.name.equals(GROUPING_ID);
    }

    public boolean isForeignKeyMember() {
        return this.name.equals(FOREIGN_KEY_MEMBER);
    }

    public boolean isRefData() {
        return this.name.equals(REF_DATA);
    }

    public boolean isTextElement() {
        return this.name.equals(TEXT_ELEMENT);
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = null;
        stringBuilder = new StringBuilder();
        stringBuilder.append("identifier: ");
        stringBuilder.append(this.name);
        stringBuilder.append("\n");
        stringBuilder.append("comments: ");
        stringBuilder.append(this.comments);
        stringBuilder.append("\n");
        stringBuilder.append("codeTypes:\n");
        for (String object : this.codeTypes.types) {
            stringBuilder.append("\t type: ");
            stringBuilder.append(object);
            stringBuilder.append("\n");
        }
        stringBuilder.append("defaultCodeType: ");
        stringBuilder.append(this.codeTypes.defaultType);
        stringBuilder.append("\n");
        stringBuilder.append("dataSourceEngineTypes:\n");
        for (DataSourceEngineType dataSourceEngineType : this.dataSourceEngineTypes.values()) {
            stringBuilder.append("\t dataSourceEngineName: ");
            stringBuilder.append((Object)dataSourceEngineType.dataSourceEngine);
            stringBuilder.append("\n");
            stringBuilder.append("\t recommendedType: ");
            stringBuilder.append(dataSourceEngineType.defaultType);
            stringBuilder.append("\n");
        }
        stringBuilder.append("parameters:\n");
        for (Parameter parameter : this.parameters) {
            stringBuilder.append("\t name: ");
            stringBuilder.append(parameter.name);
            stringBuilder.append("\n");
            stringBuilder.append("\t mandatory: ");
            stringBuilder.append(parameter.mandatory);
            stringBuilder.append("\n");
            stringBuilder.append("\t type: ");
            stringBuilder.append(parameter.type);
            stringBuilder.append("\n");
            if (parameter.lov != null) {
                stringBuilder.append("\t lov:\n");
                for (String string : parameter.lov) {
                    stringBuilder.append("\t\t value: ");
                    stringBuilder.append(string);
                    stringBuilder.append("\n");
                }
            }
            stringBuilder.append("\t defaultValue: ");
            stringBuilder.append(parameter.defaultValue);
            stringBuilder.append("\n");
            stringBuilder.append("\t comments: ");
            stringBuilder.append(parameter.comments);
            stringBuilder.append("\n");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public static class Parameter {
        public String name;
        public boolean mandatory;
        public String type;
        public Collection<String> lov;
        public String defaultValue;
        public String comments;
    }

    public static class DataSourceEngineType {
        public Constants.DataSourceEngine dataSourceEngine;
        public NullFreeImmutableSet_U<String> types;
        public String defaultType;
    }

    public static class CodeTypes {
        public NullFreeImmutableSet_U<String> types;
        public String defaultType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BroadType {
        WHOLE_NUMBER("WholeNumber"),
        DECIMAL_NUMBER("DecimalNumber"),
        TEXT("Text"),
        BINARY("Binary"),
        BOOLEAN("Boolean"),
        TEMPORAL("Temporal");

        private String identifier;

        private BroadType(String string2) {
            this.identifier = string2;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public static BroadType get(String string) {
            BroadType broadType = null;
            for (BroadType broadType2 : BroadType.values()) {
                if (!broadType2.identifier.equals(string)) continue;
                broadType = broadType2;
                break;
            }
            return broadType;
        }
    }
}

