/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration;

import com.jronimo.systemconfiguration.Constants;
import com.jronimo.util.Logger;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSource {
    private static final Logger logger = Logger.getLogger(DataSource.class);
    private String name;
    private boolean isDefault;
    private Constants.DataSourceType type;
    private String defaultSchema;
    private String auditSchema;
    private List<String> otherSchemas = new ArrayList<String>(1);
    private SequenceDetails sequenceDetails;

    public DataSource(String string, boolean bl, Constants.DataSourceType dataSourceType) {
        this.name = string;
        this.isDefault = bl;
        this.type = dataSourceType;
    }

    public DataSource(String string, boolean bl, Constants.DataSourceType dataSourceType, String string2, String string3, SequenceDetails sequenceDetails) {
        this.name = string;
        this.isDefault = bl;
        this.type = dataSourceType;
        this.defaultSchema = string2;
        this.auditSchema = string3;
        this.sequenceDetails = sequenceDetails;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public Constants.DataSourceType getType() {
        return this.type;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public boolean isDefaultSchema(String string) {
        return this.defaultSchema.equals(string);
    }

    public String getAuditSchema() {
        return this.auditSchema;
    }

    public void addOtherSchema(String string) {
        this.otherSchemas.add(string);
    }

    public List<String> getOtherSchemas() {
        return this.otherSchemas;
    }

    public boolean hasSequenceDetails() {
        return this.sequenceDetails != null;
    }

    public SequenceDetails getSequenceDetails() {
        return this.sequenceDetails;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        DataSource dataSource = null;
        if (object instanceof DataSource) {
            dataSource = (DataSource)object;
            bl = dataSource.name.equals(this.name);
        }
        return bl;
    }

    public String toString() {
        return this.name;
    }

    public static class SequenceDetails {
        public Constants.SequenceType sequenceType;
        public String sequenceTableName;
        public String groupingSequenceName;
    }
}

