/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.systemconfiguration;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.engines.dataservice.FieldValue;
import com.jronimo.engines.dataservice.Validator;
import com.jronimo.systemconfiguration.Field;
import com.jronimo.systemconfiguration.Methods;
import com.jronimo.util.Logger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintSet {
    private static final Logger logger = Logger.getLogger(ConstraintSet.class);
    private String name;
    private Validator validator;
    private Map<String, Set<Constraint>> constraints = CollectionUtils.getOrderedMap(new HashMap());

    public ConstraintSet(String string, String string2) {
        this.name = string;
        this.instantiateValidator(string2);
    }

    private void instantiateValidator(String string) {
        if (string != null) {
            // empty if block
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean hasValidator() {
        return this.validator != null;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void add(String string) {
        this.add(string, null);
    }

    public synchronized void add(String string, Constraint constraint) {
        Set set = null;
        set = this.constraints.get(string);
        if (set == null) {
            set = CollectionUtils.getOrderedSet(new HashSet(3));
            this.constraints.put(string, set);
        }
        if (constraint != null) {
            set.add((Constraint)constraint);
        }
    }

    public Map<String, Set<Constraint>> getConstraints() {
        return this.constraints;
    }

    public Set<Constraint> getConstraints(String string) {
        return this.constraints.get(string);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        ConstraintSet constraintSet = null;
        if (object instanceof ConstraintSet) {
            constraintSet = (ConstraintSet)object;
            if (constraintSet.name.equals(this.name)) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Constraint {
        public static final String ADDITIONAL_USE_TIMEZONES = "useTimezones";
        private String name;
        private FieldValue value;
        private Set<FieldValue> values;
        private Map<String, Object> additional;
        private String originalValue;
        private Collection<String> originalValues;
        private Map<String, String> originalAdditional;
        private Set<Object> codeValues;

        public Constraint(String string, Map<String, String> map) {
            this.name = string;
            this.initializeAdditional(map);
            this.originalAdditional = map;
        }

        public Constraint(String string, String string2, Map<String, String> map, Field field) {
            this.name = string;
            this.value = Methods.createNowValue(string2, field);
            if (this.value == null) {
                this.value = FieldValue.createInstanceFromStringValue(field.getDataType(), field.getCodeType(), null, string2);
            }
            this.initializeAdditional(map);
            this.originalValue = string2;
            this.originalAdditional = map;
        }

        public Constraint(String string, Set<String> set, Map<String, String> map, Field field) {
            FieldValue fieldValue = null;
            this.name = string;
            if (set != null) {
                this.values = CollectionUtils.getOrderedSet(new HashSet(set.size()));
                for (String string2 : set) {
                    fieldValue = Methods.createNowValue(string2, field);
                    if (fieldValue == null) {
                        fieldValue = FieldValue.createInstanceFromStringValue(field.getDataType(), field.getCodeType(), null, string2);
                    }
                    this.values.add(fieldValue);
                }
            }
            this.initializeAdditional(map);
            this.originalValues = set;
            this.originalAdditional = map;
        }

        private void initializeAdditional(Map<String, String> map) {
            if (map != null) {
                this.additional = CollectionUtils.getOrderedMap(new HashMap(map.size()));
                if (map.containsKey(ADDITIONAL_USE_TIMEZONES)) {
                    this.additional.put(ADDITIONAL_USE_TIMEZONES, Boolean.valueOf(map.get(ADDITIONAL_USE_TIMEZONES)));
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public boolean hasValue() {
            return this.value != null;
        }

        public boolean hasValues() {
            return this.values != null;
        }

        public FieldValue getValue() {
            return this.value;
        }

        public Set<FieldValue> getValues() {
            return this.values;
        }

        public Object getCodeValue() {
            return this.value.getCodeValue();
        }

        public synchronized Set<Object> getCodeValues() {
            Set set = null;
            set = this.codeValues;
            if (set == null && this.values != null) {
                set = CollectionUtils.getOrderedSet(new HashSet(this.values.size()));
                for (FieldValue fieldValue : this.values) {
                    set.add(fieldValue.getCodeValue());
                }
                this.codeValues = set;
            }
            return set;
        }

        public boolean hasAdditional() {
            return this.additional != null;
        }

        public boolean hasAdditionalUseTimezones() {
            boolean bl = false;
            if (this.additional != null && this.additional.containsKey(ADDITIONAL_USE_TIMEZONES)) {
                bl = true;
            }
            return bl;
        }

        public Boolean getAdditionalUseTimezones() {
            return this.additional == null ? null : (Boolean)this.additional.get(ADDITIONAL_USE_TIMEZONES);
        }

        public String getOriginalValue() {
            return this.originalValue;
        }

        public Collection<String> getOriginalValues() {
            return this.originalValues;
        }

        public Map<String, String> getOriginalAdditional() {
            return this.originalAdditional;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            boolean bl = false;
            Constraint constraint = null;
            if (object instanceof Constraint) {
                constraint = (Constraint)object;
                bl = constraint.name.equals(this.name);
            }
            return bl;
        }

        public String toString() {
            String string = null;
            string = "name: " + this.name;
            if (this.value != null) {
                string = string + "; value: " + this.value;
            }
            return string;
        }
    }
}

