/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.swing.tree;

import com.jronimo.swing.tree.PersonNode;
import com.jronimo.swing.tree.PersonalInfo;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DnDJTree
extends JTree
implements TreeSelectionListener,
DragGestureListener,
DropTargetListener,
DragSourceListener {
    private Frame parentFrame = null;
    protected TreePath selectedTreePath = null;
    protected PersonNode selectedNode = null;
    private DragSource dragSource = null;
    private DragSourceContext dragSourceContext = null;

    public DnDJTree(PersonNode personNode, Frame frame) {
        super(personNode);
        DragGestureRecognizer dragGestureRecognizer = null;
        DropTarget dropTarget = null;
        this.parentFrame = frame;
        this.addTreeSelectionListener(this);
        this.dragSource = DragSource.getDefaultDragSource();
        dragGestureRecognizer = this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        dragGestureRecognizer.setSourceActions(dragGestureRecognizer.getSourceActions() & 0xFFFFFFFB);
        dropTarget = new DropTarget(this, this);
    }

    public PersonNode getSelectedNode() {
        return this.selectedNode;
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        PersonNode personNode = null;
        Transferable transferable = null;
        Cursor cursor = null;
        personNode = this.getSelectedNode();
        if (personNode != null) {
            transferable = (Transferable)personNode.getUserObject();
            cursor = dragGestureEvent.getDragAction() == 2 ? DragSource.DefaultMoveDrop : DragSource.DefaultCopyDrop;
            this.dragSource.startDrag(dragGestureEvent, cursor, transferable, this);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = null;
        PersonalInfo personalInfo = null;
        Point point = null;
        TreePath treePath = null;
        PersonNode personNode = null;
        PersonNode personNode2 = null;
        boolean bl = false;
        PersonNode personNode3 = null;
        DefaultTreeModel defaultTreeModel = null;
        TreePath treePath2 = null;
        try {
            transferable = dropTargetDropEvent.getTransferable();
            if (!transferable.isDataFlavorSupported(PersonalInfo.INFO_FLAVOR)) {
                dropTargetDropEvent.rejectDrop();
            }
            personalInfo = (PersonalInfo)transferable.getTransferData(PersonalInfo.INFO_FLAVOR);
            point = dropTargetDropEvent.getLocation();
            treePath = this.getPathForLocation(point.x, point.y);
            final String string = this.testDropTarget(treePath, this.selectedTreePath);
            if (string != null) {
                dropTargetDropEvent.rejectDrop();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(DnDJTree.this.parentFrame, string, "Error Dialog", 0);
                    }
                });
            }
            personNode = (PersonNode)treePath.getLastPathComponent();
            personNode2 = (PersonNode)this.getSelectedNode().getParent();
            bl = dropTargetDropEvent.getDropAction() == 1;
            personNode3 = new PersonNode(personalInfo);
            try {
                if (!bl) {
                    personNode2.remove(this.getSelectedNode());
                }
                personNode.add(personNode3);
                if (bl) {
                    dropTargetDropEvent.acceptDrop(1);
                } else {
                    dropTargetDropEvent.acceptDrop(2);
                }
            }
            catch (IllegalStateException illegalStateException) {
                dropTargetDropEvent.rejectDrop();
            }
            dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            defaultTreeModel = (DefaultTreeModel)this.getModel();
            defaultTreeModel.reload(personNode2);
            defaultTreeModel.reload(personNode);
            treePath2 = new TreePath(personNode.getPath());
            this.expandPath(treePath2);
        }
        catch (IOException iOException) {
            dropTargetDropEvent.rejectDrop();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            dropTargetDropEvent.rejectDrop();
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        Point point = null;
        TreePath treePath = null;
        point = dropTargetDragEvent.getLocation();
        treePath = this.getPathForLocation(point.x, point.y);
        if (this.testDropTarget(treePath, this.selectedTreePath) == null) {
            dropTargetDragEvent.acceptDrag(3);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.selectedTreePath = treeSelectionEvent.getNewLeadSelectionPath();
        this.selectedNode = this.selectedTreePath == null ? null : (PersonNode)this.selectedTreePath.getLastPathComponent();
    }

    private String testDropTarget(TreePath treePath, TreePath treePath2) {
        String string = null;
        boolean bl = false;
        Object var5_5 = null;
        if (treePath == null) {
            string = "Invalid drop location.";
        } else if (!((PersonNode)treePath.getLastPathComponent()).getAllowsChildren()) {
            string = "This node does not allow children";
        } else if (treePath.equals(treePath2)) {
            string = "Destination cannot be same as source";
        } else if (treePath2.isDescendant(treePath)) {
            string = "Destination node cannot be a descendant.";
        } else if (treePath2.getParentPath().equals(treePath)) {
            string = "Destination node cannot be a parent.";
        }
        return string;
    }

    public static final void main(String[] stringArray) {
        Object var1_1 = null;
        PersonNode personNode = null;
        PersonNode personNode2 = null;
        PersonNode personNode3 = null;
        PersonNode personNode4 = null;
        PersonNode personNode5 = null;
        JFrame jFrame = null;
        personNode = new PersonNode(new PersonalInfo("GrandMother", false));
        personNode2 = new PersonNode(new PersonalInfo("Mother", false));
        personNode3 = new PersonNode(new PersonalInfo("Daughter", false));
        personNode4 = new PersonNode(new PersonalInfo("Baby", false));
        personNode5 = new PersonNode(new PersonalInfo("Son", true));
        personNode.add(personNode2);
        personNode2.add(personNode3);
        personNode2.add(personNode5);
        personNode3.add(personNode4);
        jFrame = new JFrame();
        jFrame.getContentPane().add(new DnDJTree(personNode, jFrame));
        jFrame.setSize(300, 300);
        jFrame.show();
    }
}

