/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.swing;

import com.jronimo.swing.ComponentFactory;
import com.jronimo.swing.GuiMethods;
import com.jronimo.swing.Popup;
import com.jronimo.util.Logger;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReorderPopup
extends JDialog
implements Popup {
    private static final Logger logger = Logger.getLogger(ReorderPopup.class);
    private List<Object> objects;
    private DefaultListModel listModel;
    private JList guiList;
    private JScrollPane scrollPane;
    private JPanel arrowPanel;
    private JPanel buttonPanel;
    private Object result;

    public ReorderPopup(JFrame jFrame, String string, boolean bl, List<Object> list, ImageIcon imageIcon, ImageIcon imageIcon2) {
        super(jFrame, string, bl);
        this.objects = list;
        this.init(jFrame, imageIcon, imageIcon2);
    }

    public ReorderPopup(JDialog jDialog, String string, boolean bl, List<Object> list, ImageIcon imageIcon, ImageIcon imageIcon2) {
        super(jDialog, string, bl);
        this.objects = list;
        this.init(jDialog, imageIcon, imageIcon2);
    }

    private void init(Container container, ImageIcon imageIcon, ImageIcon imageIcon2) {
        this.listModel = new DefaultListModel();
        for (Object object : this.objects) {
            this.listModel.addElement(object);
        }
        this.initializeEventHandlers();
        this.initializeComponents(imageIcon, imageIcon2);
        this.initializeContainers(container);
    }

    private void initializeEventHandlers() {
    }

    private void initializeComponents(ImageIcon imageIcon, ImageIcon imageIcon2) {
        this.guiList = new JList(this.listModel);
        this.guiList.setSelectionMode(0);
        if (this.guiList.getModel().getSize() > 0) {
            this.guiList.setSelectedIndex(this.guiList.getModel().getSize() - 1);
        }
        this.scrollPane = ComponentFactory.getScrollPane(this.guiList, 20, 30);
        this.arrowPanel = new ArrowPanel(imageIcon, imageIcon2);
        this.buttonPanel = new ButtonPanel();
    }

    private void initializeContainers(Container container) {
        GridBagLayout gridBagLayout = null;
        GridBagConstraints gridBagConstraints = null;
        JComponent jComponent = null;
        this.setSize(500, 400);
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        jComponent = this.scrollPane;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 10000.0;
        gridBagConstraints.weighty = 10000.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent = this.arrowPanel;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent = this.buttonPanel;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 0, 20, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        if (container != null) {
            GuiMethods.centerPopup(container, this);
        }
    }

    public void disableAll() {
    }

    public void enableAll() {
    }

    private void upButton() {
        Object e = null;
        int n = 0;
        e = this.guiList.getSelectedValue();
        if (e != null && (n = this.guiList.getSelectedIndex()) > 0) {
            this.listModel.remove(n);
            this.listModel.insertElementAt(e, --n);
            this.guiList.setSelectedValue(e, true);
        }
    }

    private void downButton() {
        Object e = null;
        int n = 0;
        e = this.guiList.getSelectedValue();
        if (e != null && (n = this.guiList.getSelectedIndex()) < this.listModel.size() - 1) {
            this.listModel.remove(n);
            this.listModel.insertElementAt(e, ++n);
            this.guiList.setSelectedValue(e, true);
        }
    }

    private void okButton() {
        ArrayList arrayList = null;
        this.hide();
        arrayList = new ArrayList(this.listModel.size());
        int n = this.listModel.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.listModel.get(i));
        }
        this.result = arrayList;
    }

    private void cancelButton() {
        this.hide();
    }

    @Override
    public Object getResult(boolean bl) {
        Object object = null;
        object = this.result;
        if (bl) {
            this.discard();
        }
        return object;
    }

    @Override
    public void discard() {
        this.dispose();
    }

    public final class ButtonPanel
    extends JPanel {
        private ActionListener okButtonListener = null;
        private ActionListener cancelButtonListener = null;
        private JButton cancelButton = null;
        private JButton okButton = null;

        public ButtonPanel() {
            this.initializeEventHandlers();
            this.initializeComponents();
            this.initializeContainers();
        }

        private void initializeEventHandlers() {
            this.okButtonListener = new OKButtonListener();
            this.cancelButtonListener = new CancelButtonListener();
        }

        private void initializeComponents() {
            this.okButton = new JButton("OK");
            this.cancelButton = new JButton("Cancel");
            this.okButton.addActionListener(this.okButtonListener);
            this.cancelButton.addActionListener(this.cancelButtonListener);
            ReorderPopup.this.getRootPane().setDefaultButton(this.okButton);
        }

        private void initializeContainers() {
            GridLayout gridLayout = null;
            gridLayout = new GridLayout(1, 2);
            gridLayout.setHgap(10);
            this.setLayout(gridLayout);
            this.add(this.okButton);
            this.add(this.cancelButton);
        }

        public class CancelButtonListener
        implements ActionListener {
            private CancelButtonListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = null;
                thread = new Thread(new Runnable(){

                    public void run() {
                        ReorderPopup.this.cancelButton();
                    }
                });
                GuiMethods.startEventThread(thread);
            }
        }

        public class OKButtonListener
        implements ActionListener {
            private OKButtonListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = null;
                thread = new Thread(new Runnable(){

                    public void run() {
                        ReorderPopup.this.okButton();
                    }
                });
                GuiMethods.startEventThread(thread);
            }
        }
    }

    public final class ArrowPanel
    extends JPanel {
        private ActionListener upButtonListener = null;
        private ActionListener downButtonListener = null;
        private JButton upButton = null;
        private JButton downButton = null;

        public ArrowPanel(ImageIcon imageIcon, ImageIcon imageIcon2) {
            this.initializeEventHandlers();
            this.initializeComponents(imageIcon, imageIcon2);
            this.initializeContainers();
        }

        private void initializeEventHandlers() {
            this.upButtonListener = new UpButtonListener();
            this.downButtonListener = new DownButtonListener();
        }

        private void initializeComponents(ImageIcon imageIcon, ImageIcon imageIcon2) {
            this.upButton = ComponentFactory.getImageButton(imageIcon, this.upButtonListener, true);
            this.downButton = ComponentFactory.getImageButton(imageIcon2, this.downButtonListener, true);
        }

        private void initializeContainers() {
            GridLayout gridLayout = null;
            gridLayout = new GridLayout(2, 1);
            gridLayout.setVgap(10);
            this.setLayout(gridLayout);
            this.add(this.upButton);
            this.add(this.downButton);
        }

        public class DownButtonListener
        implements ActionListener {
            private DownButtonListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ReorderPopup.this.downButton();
            }
        }

        public class UpButtonListener
        implements ActionListener {
            private UpButtonListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ReorderPopup.this.upButton();
            }
        }
    }
}

