/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.swing;

import com.jronimo.swing.ComponentFactory;
import com.jronimo.swing.GuiMethods;
import com.jronimo.swing.Popup;
import com.jronimo.util.Logger;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListSelectionPopup
extends JDialog
implements Popup {
    private static final Logger logger = Logger.getLogger(ListSelectionPopup.class);
    private DefaultListModel listModel;
    private JList guiList;
    private JScrollPane scrollPane;
    private JPanel buttonPanel;
    private Object result;

    public ListSelectionPopup(JFrame jFrame, String string, int n, List<Object> list, List<Object> list2) {
        super(jFrame, string, true);
        this.init(jFrame, n, list, list2);
    }

    public ListSelectionPopup(JDialog jDialog, String string, int n, List<Object> list, List<Object> list2) {
        super(jDialog, string, true);
        this.init(jDialog, n, list, list2);
    }

    private void init(Container container, int n, List<Object> list, List<Object> list2) {
        this.listModel = new DefaultListModel();
        for (Object object : list) {
            this.listModel.addElement(object);
        }
        this.initializeEventHandlers();
        this.initializeComponents(n, list2);
        this.initializeContainers(container);
    }

    private void initializeEventHandlers() {
    }

    private void initializeComponents(int n, List<Object> list) {
        this.guiList = new JList(this.listModel);
        this.guiList.setSelectionMode(n);
        this.guiList.addMouseListener(new MouseListener());
        if (list != null) {
            for (Object object : list) {
                this.guiList.setSelectedValue(object, false);
            }
        }
        this.scrollPane = ComponentFactory.getScrollPane(this.guiList, 20, 30);
        this.buttonPanel = new ButtonPanel();
    }

    private void initializeContainers(Container container) {
        GridBagLayout gridBagLayout = null;
        GridBagConstraints gridBagConstraints = null;
        JComponent jComponent = null;
        this.setSize(500, 400);
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        jComponent = this.scrollPane;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 10000.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent = this.buttonPanel;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 0, 20, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        if (container != null) {
            GuiMethods.centerPopup(container, this);
        }
    }

    public void disableAll() {
    }

    public void enableAll() {
    }

    private void okButton() {
        Object[] objectArray = null;
        this.hide();
        objectArray = this.guiList.getSelectedValues();
        this.result = new ArrayList(objectArray.length);
        for (Object object : objectArray) {
            ((ArrayList)this.result).add(object);
        }
    }

    private void cancelButton() {
        this.hide();
    }

    @Override
    public Object getResult(boolean bl) {
        Object object = null;
        object = this.result;
        if (bl) {
            this.discard();
        }
        return object;
    }

    @Override
    public void discard() {
        this.dispose();
    }

    public final class ButtonPanel
    extends JPanel {
        private ActionListener okButtonListener = null;
        private ActionListener cancelButtonListener = null;
        private JButton cancelButton = null;
        private JButton okButton = null;

        public ButtonPanel() {
            this.initializeEventHandlers();
            this.initializeComponents();
            this.initializeContainers();
        }

        private void initializeEventHandlers() {
            this.okButtonListener = new OKButtonListener();
            this.cancelButtonListener = new CancelButtonListener();
        }

        private void initializeComponents() {
            this.okButton = new JButton("OK");
            this.cancelButton = new JButton("Cancel");
            this.okButton.addActionListener(this.okButtonListener);
            this.cancelButton.addActionListener(this.cancelButtonListener);
            ListSelectionPopup.this.getRootPane().setDefaultButton(this.okButton);
        }

        private void initializeContainers() {
            GridLayout gridLayout = null;
            gridLayout = new GridLayout(1, 2);
            gridLayout.setHgap(10);
            this.setLayout(gridLayout);
            this.add(this.okButton);
            this.add(this.cancelButton);
        }

        public class CancelButtonListener
        implements ActionListener {
            private CancelButtonListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = null;
                thread = new Thread(new Runnable(){

                    public void run() {
                        ListSelectionPopup.this.cancelButton();
                    }
                });
                GuiMethods.startEventThread(thread);
            }
        }

        public class OKButtonListener
        implements ActionListener {
            private OKButtonListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = null;
                thread = new Thread(new Runnable(){

                    public void run() {
                        ListSelectionPopup.this.okButton();
                    }
                });
                GuiMethods.startEventThread(thread);
            }
        }
    }

    public class MouseListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                ListSelectionPopup.this.okButton();
            }
        }
    }
}

