/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.swing;

import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserCommandEvent;
import com.jronimo.util.Logger;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JPanel;

public class HtmlEditorPane
extends JPanel {
    private static final Logger logger = Logger.getLogger(HtmlEditorPane.class);
    private Struct struct;
    private JWebBrowser webBrowser;
    private boolean pageReady;

    public HtmlEditorPane(Struct struct) {
        this.struct = struct;
        this.init();
    }

    private void init() {
        this.webBrowser = new JWebBrowser(new NSOption[0]);
        this.webBrowser.setBarsVisible(false);
        this.webBrowser.setJavascriptEnabled(true);
        this.webBrowser.addWebBrowserListener((chrriis.dj.nativeswing.swtimpl.components.WebBrowserListener)new WebBrowserListener());
        this.webBrowser.navigate(this.struct.ckEditorUrl);
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.webBrowser);
    }

    private void pageReady() {
        String string = null;
        string = this.struct.html == null ? "loadEditor(newPage);" : (this.struct.title == null ? JWebBrowser.createJavascriptFunctionCall((String)"loadEditor", (Object[])new Object[]{this.struct.html}) : JWebBrowser.createJavascriptFunctionCall((String)"loadEditor", (Object[])new Object[]{this.struct.html, this.struct.title}));
        this.webBrowser.executeJavascript(string);
        this.pageReady = true;
    }

    private void editorReady() {
        if (this.struct.listener != null) {
            this.struct.listener.editorReady(new Event());
        }
    }

    private void save() {
        boolean bl = false;
        String string = null;
        String string2 = null;
        if (this.pageReady && this.struct.listener != null) {
            bl = (Boolean)this.webBrowser.executeJavascriptWithResult("return hasTitle()");
            if (bl) {
                string = (String)this.webBrowser.executeJavascriptWithResult("return getTitle()");
            }
            string2 = (String)this.webBrowser.executeJavascriptWithResult("return getEditorHtml()");
            this.struct.listener.save(new Event(string, string2));
        }
    }

    public void forceSave() {
        this.save();
    }

    public void focus() {
        this.webBrowser.requestFocus();
    }

    public class WebBrowserListener
    extends WebBrowserAdapter {
        public void commandReceived(WebBrowserCommandEvent webBrowserCommandEvent) {
            if (webBrowserCommandEvent.getCommand().equals(Command.PAGE_READY.toString())) {
                HtmlEditorPane.this.pageReady();
            } else if (webBrowserCommandEvent.getCommand().equals(Command.EDITOR_READY.toString())) {
                HtmlEditorPane.this.editorReady();
            } else if (webBrowserCommandEvent.getCommand().equals(Command.SAVE.toString())) {
                HtmlEditorPane.this.save();
            }
        }
    }

    public static interface Listener {
        public void editorReady(Event var1);

        public void save(Event var1);
    }

    public class Event {
        private final HtmlEditorPane source;
        private String title;
        private String html;

        private Event() {
            this.source = HtmlEditorPane.this;
        }

        private Event(String string, String string2) {
            this.source = HtmlEditorPane.this;
            this.title = string;
            this.html = string2;
        }

        public HtmlEditorPane getSource() {
            return this.source;
        }

        public String getTitle() {
            return this.title;
        }

        public String getHtml() {
            return this.html;
        }
    }

    public static final class Struct {
        public String ckEditorUrl;
        public String title;
        public String html;
        public Listener listener;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Command {
        PAGE_READY,
        EDITOR_READY,
        SAVE;

    }
}

