/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.swing;

import com.jronimo.images.Images;
import com.jronimo.swing.ComponentFactory;
import com.jronimo.swing.DirectoryBrowser;
import com.jronimo.swing.GuiMethods;
import com.jronimo.swing.Popup;
import com.jronimo.swing.PopupFactory;
import com.jronimo.util.Logger;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public final class DirectoryBrowserPopup
extends JDialog
implements Popup {
    private static final Logger logger = Logger.getLogger(DirectoryBrowserPopup.class);
    private File initialPath;
    private WindowListener windowListener;
    private JScrollPane directoryBrowserScrollPane;
    private ToolbarPanel toolbarPanel;
    private ButtonPanel buttonPanel;
    private DirectoryBrowser directoryBrowser;
    private File result;

    public DirectoryBrowserPopup(JFrame jFrame, String string, boolean bl, File file, boolean bl2) {
        this(jFrame, string, bl, file, new Dimension(400, 500), null, null, bl2);
    }

    public DirectoryBrowserPopup(JFrame jFrame, String string, boolean bl, File file, Dimension dimension, JButton jButton, JButton jButton2, boolean bl2) {
        super(jFrame, string, bl);
        this.initialPath = file;
        this.initializeEventHandlers();
        this.initializeComponents(jButton, jButton2, bl2);
        this.initializeContainers();
        this.addWindowListener(this.windowListener);
        if (dimension == null) {
            this.pack();
        } else {
            this.setSize(dimension.width, dimension.height);
        }
        if (jFrame != null) {
            GuiMethods.centerPopup(jFrame, this);
        }
    }

    private void initializeEventHandlers() {
        this.windowListener = new WindowListenerImpl();
    }

    private void initializeComponents(JButton jButton, JButton jButton2, boolean bl) {
        this.directoryBrowser = new DirectoryBrowser(this.initialPath, true, true);
        this.directoryBrowserScrollPane = new JScrollPane(this.directoryBrowser, 22, 32);
        this.toolbarPanel = new ToolbarPanel(bl);
        this.buttonPanel = new ButtonPanel(jButton, jButton2);
    }

    private void initializeContainers() {
        GridBagLayout gridBagLayout = null;
        GridBagConstraints gridBagConstraints = null;
        JComponent jComponent = null;
        int n = -1;
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        jComponent = this.directoryBrowserScrollPane;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 10000.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent = this.toolbarPanel;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 10, 20, 0);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent = this.buttonPanel;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 20, 20, 10);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
    }

    public void disableAll() {
    }

    public void enableAll() {
    }

    private void newDirectory() {
        String string = null;
        string = PopupFactory.showUserInputPopup(this, "New Directory", true, "New Directory Name:", "");
        this.directoryBrowser.addDirectory(string);
    }

    private void okButton() {
        this.hide();
        this.result = this.directoryBrowser.getSelection();
    }

    private void cancelButton() {
        this.hide();
    }

    public Object getResult(boolean bl) {
        File file = null;
        file = this.result;
        if (bl) {
            this.discard();
        }
        return file;
    }

    public void discard() {
        this.dispose();
    }

    public final class ButtonPanel
    extends JPanel {
        private ActionListener okButtonListener = null;
        private ActionListener cancelButtonListener = null;
        private JButton cancelButton = null;
        private JButton okButton = null;

        public ButtonPanel(JButton jButton, JButton jButton2) {
            this.okButton = jButton;
            this.cancelButton = jButton2;
            this.initializeEventHandlers();
            this.initializeComponents();
            this.initializeContainers();
        }

        private void initializeEventHandlers() {
            this.okButtonListener = new OKButtonListener();
            this.cancelButtonListener = new CancelButtonListener();
        }

        private void initializeComponents() {
            if (this.okButton == null) {
                this.okButton = new JButton("OK");
            }
            if (this.cancelButton == null) {
                this.cancelButton = new JButton("Cancel");
            }
            this.okButton.addActionListener(this.okButtonListener);
            this.cancelButton.addActionListener(this.cancelButtonListener);
            DirectoryBrowserPopup.this.getRootPane().setDefaultButton(this.okButton);
        }

        private void initializeContainers() {
            GridLayout gridLayout = null;
            gridLayout = new GridLayout(1, 2);
            gridLayout.setHgap(10);
            this.setLayout(gridLayout);
            this.add(this.okButton);
            this.add(this.cancelButton);
        }

        public class CancelButtonListener
        implements ActionListener {
            private CancelButtonListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = null;
                thread = new Thread(new Runnable(){

                    public void run() {
                        DirectoryBrowserPopup.this.cancelButton();
                    }
                });
                GuiMethods.startEventThread(thread);
            }
        }

        public class OKButtonListener
        implements ActionListener {
            private OKButtonListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = null;
                thread = new Thread(new Runnable(){

                    public void run() {
                        DirectoryBrowserPopup.this.okButton();
                    }
                });
                GuiMethods.startEventThread(thread);
            }
        }
    }

    public final class ToolbarPanel
    extends JPanel {
        private ActionListener newDirectoryButtonListener = null;
        private JButton newDirectoryButton = null;

        public ToolbarPanel(boolean bl) {
            this.initializeEventHandlers();
            this.initializeComponents(bl);
            this.initializeContainers(bl);
        }

        private void initializeEventHandlers() {
            this.newDirectoryButtonListener = new NewDirectoryButtonListener();
        }

        private void initializeComponents(boolean bl) {
            if (bl) {
                this.newDirectoryButton = ComponentFactory.getImageButton(Images.getImageIconResource("AddFolder_16.png"), this.newDirectoryButtonListener, true);
                this.newDirectoryButton.setToolTipText("Create Directory");
            }
        }

        private void initializeContainers(boolean bl) {
            GridLayout gridLayout = null;
            if (bl) {
                gridLayout = new GridLayout(1, 1);
                this.setLayout(gridLayout);
                this.add(this.newDirectoryButton);
            }
        }

        public class NewDirectoryButtonListener
        implements ActionListener {
            private NewDirectoryButtonListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = null;
                thread = new Thread(new Runnable(){

                    public void run() {
                        DirectoryBrowserPopup.this.newDirectory();
                    }
                });
                GuiMethods.startEventThread(thread);
            }
        }
    }

    public class WindowListenerImpl
    extends WindowAdapter {
        private WindowListenerImpl() {
        }

        public void windowOpened(WindowEvent windowEvent) {
            DirectoryBrowserPopup.this.directoryBrowser.scrollToSelection();
        }

        public void windowClosing(WindowEvent windowEvent) {
            DirectoryBrowserPopup.this.cancelButton();
        }
    }
}

