/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.swing;

import java.io.File;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppLock {
    File lock_file = null;
    FileLock lock = null;
    FileChannel lock_channel = null;
    FileOutputStream lock_stream = null;
    private static AppLock instance;

    private AppLock() {
    }

    private AppLock(String string) throws Exception {
        Object object;
        String string2 = System.getProperty("java.io.tmpdir");
        if (!string2.endsWith(System.getProperty("file.separator"))) {
            string2 = string2 + System.getProperty("file.separator");
        }
        try {
            object = MessageDigest.getInstance("MD5");
            ((MessageDigest)object).reset();
            String string3 = new BigInteger(1, ((MessageDigest)object).digest(string.getBytes())).toString(16);
            while (string3.length() < 32) {
                string3 = "0" + string3;
            }
            this.lock_file = new File(string2 + string3 + ".app_lock");
        }
        catch (Exception exception) {
            System.out.println("AppLock.AppLock() file fail");
        }
        if (this.lock_file == null) {
            this.lock_file = new File(string2 + string + ".app_lock");
        }
        this.lock_stream = new FileOutputStream(this.lock_file);
        object = "Java AppLock Object\r\nLocked by key: " + string + "\r\n";
        this.lock_stream.write(((String)object).getBytes());
        this.lock_channel = this.lock_stream.getChannel();
        this.lock = this.lock_channel.tryLock();
        if (this.lock == null) {
            throw new Exception("Can't create Lock");
        }
    }

    private void release() throws Throwable {
        if (this.lock.isValid()) {
            this.lock.release();
        }
        if (this.lock_stream != null) {
            this.lock_stream.close();
        }
        if (this.lock_channel.isOpen()) {
            this.lock_channel.close();
        }
        if (this.lock_file.exists()) {
            this.lock_file.delete();
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    public static boolean setLock(String string) {
        if (instance != null) {
            return true;
        }
        try {
            instance = new AppLock(string);
        }
        catch (Exception exception) {
            instance = null;
            return false;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                AppLock.releaseLock();
            }
        });
        return true;
    }

    public static void releaseLock() {
        try {
            if (instance == null) {
                throw new NoSuchFieldException("INSTANCE IS NULL");
            }
            instance.release();
        }
        catch (Throwable throwable) {
            Logger.getLogger(AppLock.class.getName()).log(Level.SEVERE, "Fail to release", throwable);
        }
    }
}

