/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.nfl;

import com.jronimo.collections.NullFreeMutableList;
import com.jronimo.collections.NullFreeMutableSet;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.nfl.Game;
import com.jronimo.nfl.Main;
import com.jronimo.nfl.RankedTeam;
import com.jronimo.nfl.WeekTeam;
import com.jronimo.util.FileMethods;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapper;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Week
implements Comparable<Week> {
    private static final Logger logger = Logger.getLogger(Week.class);
    private int year;
    private int number;
    private NullFreeMutableSet<RankedTeam> rankedTeams = new NullFreeMutableSet(32);
    private NullFreeMutableSet<Game> games = new NullFreeMutableSet(16);

    public Week(int n, int n2) {
        this.year = n;
        this.number = n2;
    }

    public void load() {
        StringWrapper stringWrapper = null;
        stringWrapper = new StringWrapper(this.number).pad(2, "0", false).insert(0, "_Week_").insert(0, this.year);
        this.loadRanks(stringWrapper.toString() + "_Ranks.txt");
        this.loadGames(stringWrapper.toString() + "_Games.txt");
    }

    private void loadRanks(String string) {
        NullFreeMutableList<String> nullFreeMutableList = null;
        int n = 0;
        try {
            nullFreeMutableList = FileMethods.readTextFileLines(new File(Main.directory, string));
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        for (String string2 : nullFreeMutableList) {
            this.rankedTeams.add(new RankedTeam(string2, ++n));
        }
    }

    private void loadGames(String string) {
        NullFreeMutableList<String> nullFreeMutableList = null;
        NullFreeMutableList<String> nullFreeMutableList2 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            nullFreeMutableList = FileMethods.readTextFileLines(new File(Main.directory, string));
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        for (String string5 : nullFreeMutableList) {
            nullFreeMutableList2 = new StringWrapper(string5).split("-");
            string2 = (String)nullFreeMutableList2.get(0);
            string3 = (String)nullFreeMutableList2.get(1);
            if (nullFreeMutableList2.size() == 3) {
                string4 = (String)nullFreeMutableList2.get(2);
            }
            this.games.add(new Game(string2, string3, string4));
        }
    }

    public NullFreeMutableSet<String> projectWinners() {
        NullFreeMutableSet<String> nullFreeMutableSet = null;
        RankedTeam rankedTeam = null;
        RankedTeam rankedTeam2 = null;
        String string = null;
        nullFreeMutableSet = new NullFreeMutableSet<String>(16);
        for (Game game : this.games) {
            rankedTeam = this.getTeam(game.getHomeTeam());
            rankedTeam2 = this.getTeam(game.getOpposingTeam());
            string = rankedTeam.getTeam() + "-" + rankedTeam2.getTeam() + "-";
            string = rankedTeam.getRank() < rankedTeam2.getRank() ? string + rankedTeam.getTeam() + ":" + (rankedTeam2.getRank() - rankedTeam.getRank()) : string + rankedTeam2.getTeam() + ":" + (rankedTeam.getRank() - rankedTeam2.getRank());
            nullFreeMutableSet.add(string);
        }
        return nullFreeMutableSet;
    }

    public String generateRanks() {
        String string = null;
        NullFreeMutableSet<WeekTeam> nullFreeMutableSet = null;
        RankedTeam rankedTeam = null;
        RankedTeam rankedTeam2 = null;
        nullFreeMutableSet = new NullFreeMutableSet<WeekTeam>(16);
        for (Game game : this.games) {
            rankedTeam = this.getTeam(game.getHomeTeam());
            rankedTeam2 = this.getTeam(game.getOpposingTeam());
            nullFreeMutableSet.add(new WeekTeam(rankedTeam, rankedTeam2, game));
            nullFreeMutableSet.add(new WeekTeam(rankedTeam2, rankedTeam, game));
        }
        nullFreeMutableSet.sort();
        string = nullFreeMutableSet.toString("\n");
        return string;
    }

    private RankedTeam getTeam(String string) {
        RankedTeam rankedTeam = null;
        for (RankedTeam rankedTeam2 : this.rankedTeams) {
            if (!rankedTeam2.getTeam().equals(string)) continue;
            rankedTeam = rankedTeam2;
            break;
        }
        return rankedTeam;
    }

    public int getNumber() {
        return this.number;
    }

    @Override
    public int compareTo(Week week) {
        return this.number - week.number;
    }

    public int hashCode() {
        return this.number;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        Week week = null;
        if (object instanceof Week) {
            week = (Week)object;
            if (week.number == this.number) {
                bl = true;
            }
        }
        return bl;
    }
}

