/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.nfl;

import com.jronimo.collections.NullFreeMutableSet;
import com.jronimo.nfl.Main;
import com.jronimo.nfl.Week;
import com.jronimo.util.FileMethods;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapper;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Season
implements Comparable<Season> {
    private static final Logger logger = Logger.getLogger(Season.class);
    private int year;
    private NullFreeMutableSet<Week> weeks = new NullFreeMutableSet(20);

    public Season(int n) {
        this.year = n;
    }

    public void load() {
        int n = 0;
        File file = null;
        StringWrapper stringWrapper = null;
        Week week = null;
        while ((file = new File(Main.directory, (stringWrapper = new StringWrapper(++n).pad(2, "0", false).insert(0, "_Week_").insert(0, this.year).append("_Ranks.txt")).toString())).exists()) {
            week = new Week(this.year, n);
            week.load();
            this.weeks.add(week);
        }
    }

    public void projectWinners(int n) {
        Week week = null;
        NullFreeMutableSet<String> nullFreeMutableSet = null;
        StringWrapper stringWrapper = null;
        File file = null;
        week = (Week)this.weeks.get(n - 1);
        nullFreeMutableSet = week.projectWinners();
        stringWrapper = new StringWrapper(n).pad(2, "0", false).insert(0, "_Week_").insert(0, this.year).append("_ProjectedWinners.txt");
        file = new File(Main.directory, stringWrapper.toString());
        FileMethods.writeTextFile(file, nullFreeMutableSet.toString("\n"));
    }

    public void generateRanks(int n) {
        Week week = null;
        String string = null;
        StringWrapper stringWrapper = null;
        File file = null;
        week = (Week)this.weeks.get(n - 2);
        string = week.generateRanks();
        stringWrapper = new StringWrapper(n).pad(2, "0", false).insert(0, "_Week_").insert(0, this.year).append("_Ranks.txt");
        file = new File(Main.directory, stringWrapper.toString());
        FileMethods.writeTextFile(file, string);
    }

    public int getYear() {
        return this.year;
    }

    @Override
    public int compareTo(Season season) {
        return this.year - season.year;
    }
}

