/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.nameformat;

import com.jronimo.nameformat.AbstractWord;
import com.jronimo.nameformat.NameFormat;
import com.jronimo.nameformat.WordCharacter;
import com.jronimo.util.StringWrapperWithVoidRegions;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StrictWord
extends AbstractWord {
    StrictWord(List<WordCharacter> list, NameFormat.Format format) {
        super(list, format);
    }

    @Override
    public String getCamelCase() {
        String string = null;
        string = this.camelCase;
        if (string == null) {
            this.camelCase = string = new StringWrapperWithVoidRegions(this.getText()).replaceAll(" ", "").toString();
        }
        return string;
    }

    @Override
    public String getHungarian() {
        String string = null;
        string = this.hungarian;
        if (string == null) {
            string = this.getCamelCase();
            if (this.isFirstWord) {
                string = string.toLowerCase();
            }
            this.hungarian = string;
        }
        return string;
    }

    @Override
    public String getUpperCase() {
        String string = null;
        StringBuilder stringBuilder = null;
        int n = 0;
        string = this.upperCase;
        if (string == null) {
            stringBuilder = new StringBuilder();
            for (WordCharacter wordCharacter : this.characters) {
                if (++n == 1 && wordCharacter.hasPreviousCharacter()) {
                    if (this.format.isCamelCase() || this.format.isHungarian()) {
                        stringBuilder.append((Object)NameFormat.Separator.UNDERSCORE);
                    } else if (wordCharacter.getPreviousCharacter().isSeparator()) {
                        if (wordCharacter.getPreviousCharacter().isTargetSeparator()) {
                            stringBuilder.append((Object)NameFormat.Separator.UNDERSCORE);
                        } else {
                            stringBuilder.append((Object)wordCharacter.getPreviousCharacter().getSeparator());
                        }
                    }
                }
                stringBuilder.append(wordCharacter.toUpperCase());
            }
            this.upperCase = string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public String getXmlNotation() {
        String string = null;
        StringBuilder stringBuilder = null;
        int n = 0;
        string = this.xmlNotation;
        if (string == null) {
            stringBuilder = new StringBuilder();
            for (WordCharacter wordCharacter : this.characters) {
                if (++n == 1 && wordCharacter.hasPreviousCharacter()) {
                    if (this.format.isCamelCase() || this.format.isHungarian()) {
                        stringBuilder.append((Object)NameFormat.Separator.HYPHEN);
                    } else if (wordCharacter.getPreviousCharacter().isSeparator()) {
                        if (wordCharacter.getPreviousCharacter().isTargetSeparator()) {
                            stringBuilder.append((Object)NameFormat.Separator.HYPHEN);
                        } else {
                            stringBuilder.append((Object)wordCharacter.getPreviousCharacter().getSeparator());
                        }
                    }
                }
                stringBuilder.append(wordCharacter.toLowerCase());
            }
            this.xmlNotation = string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public String getText() {
        String string = null;
        StringBuilder stringBuilder = null;
        int n = 0;
        string = this.text;
        if (string == null) {
            stringBuilder = new StringBuilder();
            for (WordCharacter wordCharacter : this.characters) {
                if (++n == 1 && wordCharacter.hasPreviousCharacter()) {
                    if (this.format.isCamelCase() || this.format.isHungarian()) {
                        stringBuilder.append((Object)NameFormat.Separator.SPACE);
                    } else if (wordCharacter.getPreviousCharacter().isSeparator()) {
                        if (wordCharacter.getPreviousCharacter().isTargetSeparator()) {
                            stringBuilder.append((Object)NameFormat.Separator.SPACE);
                        } else {
                            stringBuilder.append((Object)wordCharacter.getPreviousCharacter().getSeparator());
                        }
                    }
                }
                if (this.format.isCamelCase()) {
                    stringBuilder.append(wordCharacter);
                    continue;
                }
                if (this.format.isHungarian()) {
                    if (n == 1 && this.isFirstWord) {
                        stringBuilder.append(wordCharacter.toUpperCase());
                        continue;
                    }
                    stringBuilder.append(wordCharacter);
                    continue;
                }
                if (this.format.isUpperCase()) {
                    if (n == 1) {
                        stringBuilder.append(wordCharacter);
                        continue;
                    }
                    stringBuilder.append(wordCharacter.toLowerCase());
                    continue;
                }
                if (this.format.isXmlNotation()) {
                    if (n == 1) {
                        stringBuilder.append(wordCharacter.toUpperCase());
                        continue;
                    }
                    stringBuilder.append(wordCharacter);
                    continue;
                }
                if (!this.format.isText()) continue;
                stringBuilder.append(wordCharacter);
            }
            this.text = string = stringBuilder.toString();
        }
        return string;
    }
}

