/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.nameformat;

import com.jronimo.collections.NullFreeMutableList;
import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.nameformat.AbstractCleaner;
import com.jronimo.nameformat.AbstractNameFormat;
import com.jronimo.nameformat.NameFormat;
import com.jronimo.util.StringWrapperWithVoidRegions;
import java.util.HashMap;
import java.util.Map;

final class StrictCleaner
extends AbstractCleaner {
    StrictCleaner(String string) {
        super(string);
    }

    protected void clean(String string) {
        String string2 = null;
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        Object var4_4 = null;
        string2 = string.trim();
        if (string2.length() == 0) {
            this.cleanString = string2;
            this.format = NameFormat.Format.CAMEL_CASE;
        } else {
            stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions(string2).retainAllCharacters(AbstractNameFormat.getAllowables()).trim().removeLeadingNonLetters().removeTrailingCharacters(NameFormat.Separator.getSeparators());
            this.cleanUpSeparators(stringWrapperWithVoidRegions);
            stringWrapperWithVoidRegions.trim();
            this.determineFormat(stringWrapperWithVoidRegions);
            this.cleanString = stringWrapperWithVoidRegions.toString();
        }
    }

    private void cleanUpSeparators(StringWrapperWithVoidRegions stringWrapperWithVoidRegions) {
        Map map = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        map = CollectionUtils.getOrderedMap(new HashMap());
        if (!stringWrapperWithVoidRegions.isEmpty()) {
            if (stringWrapperWithVoidRegions.contains(NameFormat.Separator.SPACE.getString())) {
                bl = true;
            } else if (stringWrapperWithVoidRegions.isAllLowerCase()) {
                bl3 = true;
            } else {
                bl2 = true;
            }
            if (bl) {
                map.put("_", "");
                map.put("-", "");
                map.put("  ", " ");
            } else {
                map.put(" ", "");
                if (bl2) {
                    map.put("-", "");
                    map.put("__", "_");
                } else if (bl3) {
                    map.put("_", "");
                    map.put("--", "-");
                }
            }
            stringWrapperWithVoidRegions.replaceAll(map);
            stringWrapperWithVoidRegions.trim();
        }
    }

    private void determineFormat(StringWrapperWithVoidRegions stringWrapperWithVoidRegions) {
        if (stringWrapperWithVoidRegions.isEmpty()) {
            this.format = NameFormat.Format.CAMEL_CASE;
        } else if (stringWrapperWithVoidRegions.length() == 1) {
            this.format = stringWrapperWithVoidRegions.isAllUpperCase() ? NameFormat.Format.CAMEL_CASE : NameFormat.Format.HUNGARIAN;
        } else if (StrictCleaner.isTextFormat(stringWrapperWithVoidRegions)) {
            this.format = NameFormat.Format.TEXT;
        } else {
            stringWrapperWithVoidRegions.replaceAll(NameFormat.Separator.SPACE.getString(), "");
            if (StrictCleaner.isUpperCaseFormat(stringWrapperWithVoidRegions)) {
                this.format = NameFormat.Format.UPPER_CASE;
            } else {
                stringWrapperWithVoidRegions.replaceAll(NameFormat.Separator.UNDERSCORE.getString(), "");
                if (StrictCleaner.isXmlNotation(stringWrapperWithVoidRegions)) {
                    this.format = NameFormat.Format.XML_NOTATION;
                } else {
                    stringWrapperWithVoidRegions.replaceAll(NameFormat.Separator.HYPHEN.getString(), "");
                    this.format = stringWrapperWithVoidRegions.startsWithUpperCaseLetter() ? NameFormat.Format.CAMEL_CASE : NameFormat.Format.HUNGARIAN;
                }
            }
        }
    }

    private static boolean isTextFormat(StringWrapperWithVoidRegions stringWrapperWithVoidRegions) {
        return stringWrapperWithVoidRegions.contains(NameFormat.Separator.SPACE.getString());
    }

    private static boolean isUpperCaseFormat(StringWrapperWithVoidRegions stringWrapperWithVoidRegions) {
        return StrictCleaner.isRecognizedFormat(stringWrapperWithVoidRegions, NameFormat.Separator.UNDERSCORE);
    }

    private static boolean isXmlNotation(StringWrapperWithVoidRegions stringWrapperWithVoidRegions) {
        return StrictCleaner.isRecognizedFormat(stringWrapperWithVoidRegions, NameFormat.Separator.HYPHEN);
    }

    private static boolean isRecognizedFormat(StringWrapperWithVoidRegions stringWrapperWithVoidRegions, NameFormat.Separator separator) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        NullFreeMutableList<String> nullFreeMutableList = null;
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions2 = null;
        switch (separator) {
            case SPACE: {
                bl4 = true;
                break;
            }
            case UNDERSCORE: {
                bl2 = true;
                break;
            }
            case HYPHEN: {
                bl3 = true;
            }
        }
        if (stringWrapperWithVoidRegions.contains(NameFormat.Separator.SPACE.getString()) && !separator.isSpace()) {
            bl = false;
        } else if (separator.isSpace() && !stringWrapperWithVoidRegions.contains(NameFormat.Separator.SPACE.getString())) {
            bl = false;
        } else if (separator.isUnderscore() && !stringWrapperWithVoidRegions.contains(NameFormat.Separator.UNDERSCORE.getString())) {
            bl = stringWrapperWithVoidRegions.isAllUpperCase();
        } else if (separator.isHyphen() && !stringWrapperWithVoidRegions.contains(NameFormat.Separator.HYPHEN.getString())) {
            bl = false;
        } else {
            nullFreeMutableList = stringWrapperWithVoidRegions.split(separator.getString(), true, true, true);
            for (String string : nullFreeMutableList) {
                stringWrapperWithVoidRegions2 = new StringWrapperWithVoidRegions(string);
                if (stringWrapperWithVoidRegions2.isEmpty()) {
                    bl = false;
                } else if (stringWrapperWithVoidRegions2.startsWithCharacter(NameFormat.Separator.getSeparators()) || stringWrapperWithVoidRegions2.endsWithCharacter(NameFormat.Separator.getSeparators())) {
                    bl = false;
                } else if (bl2 && !stringWrapperWithVoidRegions2.isAllUpperCase()) {
                    bl = false;
                } else if (bl3 && !stringWrapperWithVoidRegions2.isAllLowerCase()) {
                    bl = false;
                } else if (bl4) {
                    bl = StrictCleaner.isCamelCaseWord(stringWrapperWithVoidRegions2);
                }
                if (bl) continue;
                break;
            }
        }
        return bl;
    }
}

