/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.nameformat;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.nameformat.AbstractRulesConfig;
import com.jronimo.nameformat.MessyTextRulesConfig;
import com.jronimo.nameformat.NameFormat;
import com.jronimo.nameformat.RulesConfig;
import com.jronimo.nameformat.SpecifiedFormatRulesConfig;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rules {
    public static final NameFormat.Separator[] ALLOWABLE_OTHER_SEPARATORS = new NameFormat.Separator[]{NameFormat.Separator.UNDERSCORE, NameFormat.Separator.HYPHEN};
    private String specifiedString;
    private Collection<NameFormat.Separator> otherAllowableSeparators;
    private boolean retainConsecutiveUpperCase;
    private NameFormat.Format specifiedFormat;
    private boolean isMessyText;
    private Map<String, String> preReplacements;
    private Map<String, String> postReplacements;

    public Rules(RulesConfig rulesConfig) {
        AbstractRulesConfig abstractRulesConfig = null;
        Assert.errorParam(rulesConfig == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "mode"));
        abstractRulesConfig = (AbstractRulesConfig)rulesConfig;
        this.specifiedString = abstractRulesConfig.getSpecifiedString();
        this.otherAllowableSeparators = CollectionUtils.arrayToSet((Object[])abstractRulesConfig.getOtherAllowableSeparators(), true);
        this.retainConsecutiveUpperCase = abstractRulesConfig.getRetainConsecutiveUpperCase();
        this.preReplacements = CollectionUtils.getImmutableMap(abstractRulesConfig.getPreReplacements());
        this.postReplacements = CollectionUtils.getImmutableMap(abstractRulesConfig.getPostReplacements());
        if (rulesConfig instanceof SpecifiedFormatRulesConfig) {
            this.specifiedFormat = ((SpecifiedFormatRulesConfig)rulesConfig).getSpecifiedFormat();
        }
        if (rulesConfig instanceof MessyTextRulesConfig) {
            this.isMessyText = true;
        }
        if (this.otherAllowableSeparators.size() > 0) {
            Assert.errorParam(this.otherAllowableSeparators.contains((Object)NameFormat.Separator.SPACE), new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_CONTAIN, "otherAllowableSeparators", NameFormat.Separator.SPACE.toString()));
            Assert.errorParam(!CollectionUtils.containsOnly(this.otherAllowableSeparators, (Object[])ALLOWABLE_OTHER_SEPARATORS), new ResourceTextPointer((Object)ResourceTextIdentifiers.CONTAINS_UNEXPECTED_CONTENT, "otherAllowableSeparators"));
        }
    }

    public String getSpecifiedString() {
        return this.specifiedString;
    }

    public NameFormat.Format getSpecifiedFormat() {
        return this.specifiedFormat;
    }

    public NameFormat.Separator[] getOtherAllowableSeparators() {
        return this.otherAllowableSeparators.toArray(new NameFormat.Separator[0]);
    }

    public boolean getRetainConsecutiveUpperCase() {
        return this.retainConsecutiveUpperCase;
    }

    public Map<String, String> getPreReplacements() {
        return this.preReplacements;
    }

    public Map<String, String> getPostReplacements() {
        return this.postReplacements;
    }

    public boolean isSimpleNameFormat() {
        return !this.isSpecifiedFormat() && !this.isMessyText();
    }

    public boolean isSpecifiedFormat() {
        return this.specifiedFormat != null;
    }

    public boolean isMessyText() {
        return this.isMessyText;
    }
}

