/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.nameformat;

import com.jronimo.nameformat.NameFormat;
import com.jronimo.nameformat.Word;
import com.jronimo.nameformat.Words;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractWords
implements Words {
    protected String cleanString;
    protected NameFormat.Format format;
    protected String camelCase;
    protected String hungarian;
    protected String upperCase;
    protected String xmlNotation;
    protected String text;
    protected List<Word> words;
    protected List<String> wordsAsStrings;

    AbstractWords(String string, NameFormat.Format format) {
        this.cleanString = string;
        this.format = format;
        this.loadWords();
    }

    protected abstract void loadWords();

    public String getCleanString() {
        return this.cleanString;
    }

    public NameFormat.Format getFormat() {
        return this.format;
    }

    @Override
    public synchronized String getCamelCase() {
        String string = null;
        StringBuilder stringBuilder = null;
        string = this.camelCase;
        if (string == null) {
            stringBuilder = new StringBuilder();
            for (Word word : this.words) {
                stringBuilder.append(word.getCamelCase());
            }
            this.camelCase = string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public synchronized String getHungarian() {
        String string = null;
        StringBuilder stringBuilder = null;
        string = this.hungarian;
        if (string == null) {
            stringBuilder = new StringBuilder();
            for (Word word : this.words) {
                stringBuilder.append(word.getHungarian());
            }
            this.hungarian = string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public synchronized String getUpperCase() {
        String string = null;
        StringBuilder stringBuilder = null;
        string = this.upperCase;
        if (string == null) {
            stringBuilder = new StringBuilder();
            for (Word word : this.words) {
                stringBuilder.append(word.getUpperCase());
            }
            this.upperCase = string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public synchronized String getXmlNotation() {
        String string = null;
        StringBuilder stringBuilder = null;
        string = this.xmlNotation;
        if (string == null) {
            stringBuilder = new StringBuilder();
            for (Word word : this.words) {
                stringBuilder.append(word.getXmlNotation());
            }
            this.xmlNotation = string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public synchronized String getText() {
        String string = null;
        StringBuilder stringBuilder = null;
        string = this.text;
        if (string == null) {
            stringBuilder = new StringBuilder();
            for (Word word : this.words) {
                stringBuilder.append(word.getText());
            }
            this.text = string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public int getWordCount() {
        return this.words.size();
    }

    @Override
    public List<String> getWords() {
        List<String> list = null;
        list = this.wordsAsStrings;
        if (list == null) {
            list = new ArrayList<String>(this.words.size());
            for (Word word : this.words) {
                list.add(word.toString());
            }
            this.wordsAsStrings = list;
        }
        return list;
    }
}

