/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.nameformat;

import com.jronimo.nameformat.NameFormat;
import com.jronimo.nameformat.WordCharacter;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.StringWrapperWithVoidRegions;

abstract class AbstractWordCharacter
implements WordCharacter {
    protected WordCharacter previousCharacter;
    protected String currentCharacter;
    protected WordCharacter nextCharacter;
    private Boolean isWordStart;
    protected NameFormat.Format format;
    protected boolean isSeparator;
    protected boolean isTargetSeparator;
    protected boolean isDigit;
    protected boolean isLetter;
    protected boolean isUpperCase;
    protected boolean isLowerCase;
    protected NameFormat.Separator separator;

    protected AbstractWordCharacter(WordCharacter wordCharacter, String string, WordCharacter wordCharacter2, Boolean bl, NameFormat.Format format) {
        Object var6_6 = null;
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        Assert.errorParam(string == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "currentCharacter"));
        this.previousCharacter = wordCharacter;
        this.currentCharacter = string;
        this.nextCharacter = wordCharacter2;
        if (bl != null && bl.booleanValue()) {
            this.isWordStart = true;
        }
        this.format = format;
        this.separator = NameFormat.Separator.get(string);
        if (this.separator != null) {
            this.isSeparator = true;
            boolean bl2 = this.isTargetSeparator = this.separator == format.getSeparator();
            if (this.isWordStart == null) {
                this.isWordStart = false;
            }
        } else {
            stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions(string);
            if (stringWrapperWithVoidRegions.containsOnlyLetters()) {
                this.isLetter = true;
                this.isUpperCase = stringWrapperWithVoidRegions.containsOnlyUpperCaseLetters();
                this.isLowerCase = !this.isUpperCase;
            }
            boolean bl3 = this.isDigit = !this.isLetter;
            if (this.previousCharacter == null || this.previousCharacter.isSeparator()) {
                this.isWordStart = true;
            }
            if (this.isWordStart == null) {
                this.isWordStart = this.determineIfIsWordStart();
            }
        }
    }

    protected abstract boolean determineIfIsWordStart();

    public boolean isWordStart() {
        return this.isWordStart;
    }

    public boolean hasPreviousCharacter() {
        return this.previousCharacter != null;
    }

    public WordCharacter getPreviousCharacter() {
        return this.previousCharacter;
    }

    public boolean hasNextCharacter() {
        return this.nextCharacter != null;
    }

    public WordCharacter getNextCharacter() {
        return this.nextCharacter;
    }

    public boolean isSeparator() {
        return this.isSeparator;
    }

    public boolean isTargetSeparator() {
        return this.isTargetSeparator;
    }

    public NameFormat.Separator getSeparator() {
        return this.separator;
    }

    public boolean isDigit() {
        return this.isDigit;
    }

    public boolean isLetter() {
        return this.isLetter;
    }

    public boolean isUpperCase() {
        return this.isUpperCase;
    }

    public boolean isLowerCase() {
        return this.isLowerCase;
    }

    public String toUpperCase() {
        return this.currentCharacter.toUpperCase();
    }

    public String toLowerCase() {
        return this.currentCharacter.toLowerCase();
    }

    public String toString() {
        return this.currentCharacter;
    }
}

