/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.nameformat;

import com.jronimo.nameformat.NameFormat;
import com.jronimo.nameformat.Word;
import com.jronimo.nameformat.WordCharacter;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.StringWrapperWithVoidRegions;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractWord
implements Word {
    protected List<WordCharacter> characters;
    protected NameFormat.Format format;
    protected boolean isFirstWord;
    protected String camelCase;
    protected String hungarian;
    protected String upperCase;
    protected String xmlNotation;
    protected String text;

    protected AbstractWord(List<WordCharacter> list, NameFormat.Format format) {
        Assert.errorParam(list == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "characters"));
        Assert.errorParam(list.size() == 0, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_EMPTY, "characters"));
        Assert.unexpected(!list.get(0).isWordStart(), "The first character must be the start of a word.");
        this.format = format;
        this.characters = new ArrayList<WordCharacter>(8);
        if (!list.get(0).hasPreviousCharacter()) {
            this.isFirstWord = true;
        }
        this.extractWord(list);
    }

    protected void extractWord(List<WordCharacter> list) {
        int n = 0;
        boolean bl = false;
        for (WordCharacter wordCharacter : list) {
            if (++n == 1) {
                boolean bl2 = this.isFirstWord = !wordCharacter.hasPreviousCharacter();
            }
            if (bl) {
                if (wordCharacter.isWordStart()) break;
                if (wordCharacter.isSeparator()) continue;
                this.characters.add(wordCharacter);
                continue;
            }
            if (!wordCharacter.isWordStart()) continue;
            this.characters.add(wordCharacter);
            bl = true;
        }
        if (n < list.size()) {
            --n;
        }
        for (int i = 1; i <= n; ++i) {
            list.remove(0);
        }
    }

    @Override
    public String getCamelCaseWord() {
        return this.removeLeadingTrailingSeparators(this.getCamelCase());
    }

    @Override
    public String getHungarianWord() {
        return this.removeLeadingTrailingSeparators(this.getHungarian());
    }

    @Override
    public String getUpperCaseWord() {
        return this.removeLeadingTrailingSeparators(this.getUpperCase());
    }

    @Override
    public String getXmlNotationWord() {
        return this.removeLeadingTrailingSeparators(this.getXmlNotation());
    }

    @Override
    public String getTextWord() {
        return this.removeLeadingTrailingSeparators(this.getText());
    }

    private String removeLeadingTrailingSeparators(String string) {
        StringWrapperWithVoidRegions stringWrapperWithVoidRegions = null;
        stringWrapperWithVoidRegions = new StringWrapperWithVoidRegions(string);
        while (stringWrapperWithVoidRegions.length() > 0 && stringWrapperWithVoidRegions.startsWithCharacter(NameFormat.Separator.getSeparators())) {
            stringWrapperWithVoidRegions.deleteFirst();
        }
        while (stringWrapperWithVoidRegions.length() > 0 && stringWrapperWithVoidRegions.endsWithCharacter(NameFormat.Separator.getSeparators())) {
            stringWrapperWithVoidRegions.deleteLast();
        }
        return stringWrapperWithVoidRegions.toString();
    }

    public String toString() {
        String string = null;
        if (this.format.isCamelCase()) {
            string = this.getCamelCaseWord();
        } else if (this.format.isHungarian()) {
            string = this.getHungarianWord();
        } else if (this.format.isUpperCase()) {
            string = this.getUpperCaseWord();
        } else if (this.format.isXmlNotation()) {
            string = this.getXmlNotationWord();
        } else if (this.format.isText()) {
            string = this.getTextWord();
        }
        return string;
    }
}

