/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.nameformat;

import com.jronimo.collections.collection.CollectionUtils;
import com.jronimo.nameformat.Cleaner;
import com.jronimo.nameformat.NameFormat;
import com.jronimo.nameformat.Words;
import com.jronimo.text.ResourceText;
import com.jronimo.text.ResourceTextIdentifiers;
import com.jronimo.text.ResourceTextPointer;
import com.jronimo.util.Assert;
import com.jronimo.util.Logger;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractNameFormat
implements NameFormat {
    private static final Logger logger = Logger.getLogger(AbstractNameFormat.class);
    protected String originalString;
    protected String cleanString;
    protected NameFormat.Format format;
    protected Words words;

    public AbstractNameFormat(String string, Cleaner cleaner) {
        Assert.errorParam(string == null, new ResourceTextPointer((Object)ResourceTextIdentifiers.MUST_NOT_BE_NULL, "string"));
        this.originalString = string;
        this.cleanString = cleaner.getCleanString();
        this.format = cleaner.getFormat();
        this.words = this.getWords();
    }

    protected abstract Words getWords();

    @Override
    public NameFormat.Format getFormat() {
        return this.format;
    }

    @Override
    public String getCamelCase() {
        return this.words.getCamelCase();
    }

    @Override
    public String getHungarian() {
        return this.words.getHungarian();
    }

    @Override
    public String getUpperCase() {
        return this.words.getUpperCase();
    }

    @Override
    public String getXmlNotation() {
        return this.words.getXmlNotation();
    }

    @Override
    public String getText() {
        return this.words.getText();
    }

    @Override
    public int getWordCount() {
        return this.words.getWordCount();
    }

    @Override
    public List<String> getDetectedWords() {
        return CollectionUtils.collectionToList(this.words.getWords());
    }

    public String toString() {
        StringBuilder stringBuilder = null;
        stringBuilder = new StringBuilder();
        stringBuilder.append("\ncamelCase: " + this.getCamelCase());
        stringBuilder.append("\nhungarian: " + this.getHungarian());
        stringBuilder.append("\nupperCase: " + this.getUpperCase());
        stringBuilder.append("\nxmlNotation: " + this.getXmlNotation());
        stringBuilder.append("\ntext: " + this.getText());
        return stringBuilder.toString();
    }

    public static String getAllowables() {
        return ResourceText.getText((Object)ResourceTextIdentifiers.DIGITS) + ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_LOWER_CASE) + ResourceText.getText((Object)ResourceTextIdentifiers.ALPHABET_UPPER_CASE) + " -_";
    }
}

