/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.services.useraccount.actions;

import com.jronimo.messageserver.server.facts.active.MessageFacts;
import com.jronimo.messageserver.server.facts.objectmodel.ServerFacts;
import com.jronimo.messageserver.server.model.Action;
import com.jronimo.messageserver.server.model.ActionResult;
import com.jronimo.messageserver.server.model.Issue;
import com.jronimo.messageserver.server.model.UserAccount;
import com.jronimo.messageserver.services.useraccount.util.Constants;
import com.jronimo.messageserver.services.useraccount.util.Methods;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;

public class SignUp
implements Action {
    private static final Logger logger = Logger.getLogger(SignUp.class);
    private MessageFacts messageFacts;
    private ServerFacts serverFacts;
    private XmlElement xmlMessageDetails;

    public SignUp(MessageFacts messageFacts) {
        this.messageFacts = messageFacts;
        this.serverFacts = messageFacts.getServerFacts();
        this.xmlMessageDetails = messageFacts.getXmlMessage().getOptionalElement("details");
    }

    public ActionResult execute() {
        ActionResult actionResult = new ActionResult();
        String string = null;
        String string2 = null;
        String string3 = null;
        UserAccount userAccount = null;
        XmlElement xmlElement = null;
        if (this.serverFacts.isMaster() && this.serverFacts.getUserAccountStrategy().isUser()) {
            if (this.xmlMessageDetails == null) {
                actionResult.addIssue(Issue.NO_DETAILS);
            } else if (!this.xmlMessageDetails.hasElements("identifier", "pass", "display-name")) {
                actionResult.addIssue(Issue.INCOMPLETE_DETAILS);
            }
            if (!actionResult.hasIssues()) {
                string = this.xmlMessageDetails.getText("identifier");
                string2 = this.xmlMessageDetails.getText("pass");
                string3 = this.xmlMessageDetails.getText("display-name");
                if (!Methods.validateIdentifier(this.serverFacts, string)) {
                    actionResult.addIssue(Constants.ISSUE_INVALID_IDENTIFIER);
                }
                if (!Methods.validatePass(this.serverFacts, string2)) {
                    actionResult.addIssue(Constants.ISSUE_INVALID_PASS);
                }
                if (!Methods.validateDisplayName(this.serverFacts, string3)) {
                    actionResult.addIssue(Constants.ISSUE_INVALID_DISPLAY_NAME);
                }
            }
            if (!actionResult.hasIssues() && Methods.hasIdentifier(this.serverFacts, string)) {
                actionResult.addIssue(Issue.ALREADY_EXISTS);
            }
            if (!actionResult.hasIssues()) {
                userAccount = this.serverFacts.getUserAccounts().createUserAccount(this.serverFacts, string, string2, string3);
                Methods.sendValidationEmail(this.messageFacts, userAccount, this.serverFacts.getSignUpValidationMessage());
                xmlElement = XmlElementFactory.create("details");
                xmlElement.addElement("user-id").setLong(userAccount.getId());
                actionResult.setSuccess(true);
                actionResult.setXmlResponseDetails(xmlElement);
            }
        } else {
            actionResult.addIssue(Issue.INACTIVE_ACTION);
        }
        return actionResult;
    }
}

