/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.services.useraccount.actions;

import com.jronimo.messageserver.server.facts.active.MessageFacts;
import com.jronimo.messageserver.server.facts.objectmodel.ServerFacts;
import com.jronimo.messageserver.server.model.Action;
import com.jronimo.messageserver.server.model.ActionResult;
import com.jronimo.messageserver.server.model.Issue;
import com.jronimo.messageserver.server.model.UserAccount;
import com.jronimo.messageserver.services.useraccount.util.Constants;
import com.jronimo.messageserver.services.useraccount.util.Methods;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;

public class ResetIdentifier
implements Action {
    private static final Logger logger = Logger.getLogger(ResetIdentifier.class);
    private MessageFacts messageFacts;
    private ServerFacts serverFacts;
    private XmlElement xmlMessageDetails;

    public ResetIdentifier(MessageFacts messageFacts) {
        this.messageFacts = messageFacts;
        this.serverFacts = messageFacts.getServerFacts();
        this.xmlMessageDetails = messageFacts.getXmlMessage().getOptionalElement("details");
    }

    public ActionResult execute() {
        ActionResult actionResult = new ActionResult();
        String string = null;
        String string2 = null;
        String string3 = null;
        UserAccount userAccount = null;
        XmlElement xmlElement = null;
        if (this.serverFacts.isMaster() && this.serverFacts.getUserAccountStrategy().isUser()) {
            if (this.xmlMessageDetails == null) {
                actionResult.addIssue(Issue.NO_DETAILS);
            } else if (!this.xmlMessageDetails.hasElements("identifier", "pass", "new-identifier")) {
                actionResult.addIssue(Issue.INCOMPLETE_DETAILS);
            }
            if (!actionResult.hasIssues()) {
                string = this.xmlMessageDetails.getText("identifier");
                string2 = this.xmlMessageDetails.getText("pass");
                string3 = this.xmlMessageDetails.getText("new-identifier");
                if (!Methods.validateIdentifier(this.serverFacts, string)) {
                    actionResult.addIssue(Constants.ISSUE_INVALID_IDENTIFIER);
                }
                if (!Methods.validatePass(this.serverFacts, string2)) {
                    actionResult.addIssue(Constants.ISSUE_INVALID_PASS);
                }
                if (!Methods.validateIdentifier(this.serverFacts, string3)) {
                    actionResult.addIssue(Constants.ISSUE_INVALID_NEW_IDENTIFIER);
                }
            }
            if (!actionResult.hasIssues()) {
                userAccount = this.serverFacts.getUserAccounts().getUserAccount(string);
                if (userAccount == null) {
                    actionResult.addIssue(Constants.ISSUE_UNRECOGNIZED_IDENTIFIER);
                } else if (!userAccount.isValidated()) {
                    actionResult.addIssue(Constants.ISSUE_NOT_VALIDATED);
                } else if (!userAccount.hasPass(string2)) {
                    actionResult.addIssue(Constants.ISSUE_UNRECOGNIZED_PASS);
                } else if (string.equals(string3)) {
                    actionResult.addIssue(Issue.NO_CHANGE);
                }
            }
            if (!actionResult.hasIssues()) {
                this.serverFacts.getUserAccounts().resetUserAccountIdentifier(this.serverFacts, userAccount, string3);
                Methods.sendValidationEmail(this.messageFacts, userAccount, this.serverFacts.getResetIdentifierValidationMessage());
                xmlElement = XmlElementFactory.create("details");
                actionResult.setSuccess(true);
                actionResult.setXmlResponseDetails(xmlElement);
            }
        } else {
            actionResult.addIssue(Issue.INACTIVE_ACTION);
        }
        return actionResult;
    }
}

