/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.services.session;

import com.jronimo.messageserver.server.facts.active.MessageFacts;
import com.jronimo.messageserver.server.facts.objectmodel.ServerFacts;
import com.jronimo.messageserver.server.model.Action;
import com.jronimo.messageserver.server.model.ActionResult;
import com.jronimo.messageserver.server.model.Issue;
import com.jronimo.messageserver.server.model.UserAccount;
import com.jronimo.messageserver.util.Methods;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;

public class Create
implements Action {
    private static final Logger logger = Logger.getLogger(Create.class);
    private MessageFacts messageFacts;
    private ServerFacts serverFacts;
    private XmlElement xmlMessageDetails;

    public Create(MessageFacts messageFacts) {
        this.messageFacts = messageFacts;
        this.serverFacts = messageFacts.getServerFacts();
        this.xmlMessageDetails = messageFacts.getXmlMessage().getOptionalElement("details");
    }

    public ActionResult execute() {
        ActionResult actionResult = new ActionResult();
        String string = null;
        UserAccount userAccount = null;
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        if (this.serverFacts.isMaster()) {
            if (this.xmlMessageDetails == null) {
                actionResult.addIssue(Issue.INCOMPLETE_DETAILS);
            } else {
                string = this.xmlMessageDetails.getOptionalText("auth-bundle");
                if (Methods.isEmpty(string)) {
                    actionResult.addIssue(Issue.INCOMPLETE_DETAILS);
                } else {
                    userAccount = this.serverFacts.getAuthBundles().checkAuthBundle(string);
                    if (userAccount == null) {
                        actionResult.addIssue(Issue.NOT_FOUND);
                    } else {
                        xmlElement = XmlElementFactory.create("details");
                        xmlElement2 = xmlElement.addElement("user");
                        xmlElement2.addElement("id").setLong(userAccount.getId());
                        xmlElement2.addElement("identifier").setText(userAccount.getIdentifier());
                        xmlElement2.addElement("display-name").setText(userAccount.getDisplayName());
                        actionResult.setSuccess(true);
                        actionResult.setXmlResponseDetails(xmlElement);
                    }
                }
            }
        } else {
            actionResult.addIssue(Issue.INACTIVE_ACTION);
        }
        return actionResult;
    }
}

