/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.services.authentication.util;

import com.jronimo.util.NameFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Action {
    AUTHENTICATE,
    TOUCH,
    LOGOUT,
    VALIDATE,
    CREATE_USER,
    UNRECOGNIZED;

    private NameFormat nameFormat;

    public boolean isAuthenticate() {
        return this == AUTHENTICATE;
    }

    public boolean isLogout() {
        return this == LOGOUT;
    }

    public boolean isTouch() {
        return this == TOUCH;
    }

    public boolean isValidate() {
        return this == VALIDATE;
    }

    public boolean isCreateUser() {
        return this == CREATE_USER;
    }

    public boolean isUnrecognized() {
        return this == UNRECOGNIZED;
    }

    public NameFormat getNameFormat() {
        return this.nameFormat;
    }

    public String toXmlNotation() {
        return this.nameFormat.getXmlNotation();
    }

    public static Action match(String string) {
        Action action = null;
        try {
            action = Action.valueOf(new NameFormat(string).getUpperCase());
        }
        catch (Exception exception) {
            action = UNRECOGNIZED;
        }
        return action;
    }
}

