/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.services.authentication.processes;

import com.jronimo.collections.MutableSet;
import com.jronimo.documenter.gui.FileMethods;
import com.jronimo.messageserver.server.facts.objectmodel.ServerFacts;
import com.jronimo.messageserver.server.model.ActionResult;
import com.jronimo.messageserver.services.authentication.facts.objectmodel.ServiceFacts;
import com.jronimo.messageserver.services.authentication.facts.objectmodel.UserFacts;
import com.jronimo.messageserver.services.authentication.util.UserDetailsValidator;
import com.jronimo.messageserver.util.Methods;
import com.jronimo.temporal.DateTime;
import com.jronimo.util.EncryptionUtils;
import com.jronimo.util.Logger;
import com.jronimo.util.StringRegistry;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.util.Collection;

public class CreateUser {
    private static final Logger logger = Logger.getLogger(CreateUser.class);
    private XmlElement xmlMessage;
    private ServiceFacts serverFacts;
    private Collection<String> issues = new MutableSet<String>(2);
    private StringRegistry stringRegistry = null;
    private UserDetailsValidator userDetailsValidator = null;
    private boolean isUserManaged = false;
    private String identifier;
    private String password;
    private boolean validated;
    private DateTime validationExpiry;
    private String validationKey;
    private UserFacts user;
    private XmlElement xml;

    private CreateUser(ServerFacts serverFacts, XmlElement xmlElement) {
        this.xmlMessage = xmlElement;
    }

    public static ActionResult execute(ServerFacts serverFacts, XmlElement xmlElement) {
        return new CreateUser(serverFacts, xmlElement).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionResult execute() {
        ActionResult actionResult = null;
        XmlElement xmlElement = null;
        boolean bl = true;
        long l = 0L;
        xmlElement = this.xmlMessage.getElement("user");
        this.identifier = xmlElement.getText("identifier");
        this.password = xmlElement.getText("password");
        if (this.isUserManaged) {
            this.validated = false;
            this.validationExpiry = DateTime.addDays(DateTime.now(false), 2);
            this.validationKey = Methods.getRandomString(10);
            bl = false;
        }
        String string = this.stringRegistry.get("identifier:" + this.identifier);
        synchronized (string) {
            this.userDetailsValidator.validateUsername(this.identifier, this.issues);
            this.userDetailsValidator.validatePassword(this.password, this.issues);
            if (this.issues.isEmpty()) {
                File file = this.serverFacts.getUsersXmlFile();
                synchronized (file) {
                    this.xml = XmlElementFactory.load(this.serverFacts.getUsersXmlFile());
                    l = this.getNextUserId();
                    this.user = new UserFacts(l, this.identifier, EncryptionUtils.hash(this.password), this.validated, this.validationExpiry, this.validationKey, bl);
                    this.xml.addElement(this.user.getXml(true, true, true, true));
                    FileMethods.writeTextFile(this.serverFacts.getUsersXmlFile(), this.xml.toString());
                    this.serverFacts.addUser(this.user);
                }
            } else {
                for (String string2 : this.issues) {
                    actionResult.addIssue(string2);
                }
            }
        }
        if (this.isUserManaged) {
            this.sendValidationEmail();
        }
        return actionResult;
    }

    private long getNextUserId() {
        long l = 0L;
        XmlElement xmlElement = null;
        xmlElement = this.xml.getElement("next-id");
        l = xmlElement.getLong();
        xmlElement.setLong(l + 1L);
        return l;
    }

    private void sendValidationEmail() {
        String string = null;
        string = "/auth?action=validate&key=" + this.user.getId() + "value=" + this.validationExpiry.getTemporalValue() + "-" + this.validationKey;
    }
}

