/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.services.authentication.facts.objectmodel;

import com.jronimo.documenter.gui.Methods;
import com.jronimo.temporal.DateTime;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.util.HashMap;
import java.util.Map;

public class UserFacts {
    private static final Logger logger = Logger.getLogger(UserFacts.class);
    private long id;
    private String identifier;
    private String pass;
    private boolean validated;
    private DateTime validationExpiry;
    private String validationKey;
    private boolean resetPassword;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public UserFacts(long l, String string, String string2, boolean bl, DateTime dateTime, String string3, boolean bl2) {
        this.id = l;
        this.identifier = string;
        this.pass = string2;
        this.validated = bl;
        this.validationExpiry = dateTime;
        this.validationKey = string3;
        this.resetPassword = bl2;
    }

    public long getId() {
        return this.id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getPass() {
        return this.pass;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public boolean hasValidationExpiry() {
        return this.validationExpiry != null;
    }

    public boolean hasValidationExpiry(DateTime dateTime) {
        return !Methods.anyNull(this.validationExpiry, dateTime) && Methods.bothEqual(this.validationExpiry, dateTime);
    }

    public DateTime getValidationExpiry() {
        return this.validationExpiry;
    }

    public boolean hasValidationKey() {
        return this.validationKey != null;
    }

    public boolean hasValidationKey(String string) {
        return !Methods.anyNull(this.validationKey, string) && Methods.bothEqual(this.validationKey, string);
    }

    public String getValidationKey() {
        return this.validationKey;
    }

    public void setResetPassword(boolean bl) {
        this.resetPassword = bl;
    }

    public boolean getResetPassword() {
        return this.resetPassword;
    }

    public boolean isGuest() {
        return this.identifier.equals("Guest");
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public XmlElement getXml(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        XmlElement xmlElement = XmlElementFactory.create("user");
        xmlElement.addElement("id").setLong(this.id);
        if (bl) {
            xmlElement.addElement("username").setText(this.identifier);
        }
        if (bl2) {
            xmlElement.addElement("password").setText(this.pass);
        }
        if (this.validated) {
            xmlElement.addElement("validated").setBoolean(this.validated);
        }
        if (bl4 && !this.validated && !Methods.anyNull(this.validationExpiry, this.validationKey)) {
            xmlElement.addElement("validation-expiry").setLong(this.validationExpiry.getTemporalValue());
            xmlElement.addElement("validation-key").setText(this.validationKey);
        }
        if (this.resetPassword) {
            xmlElement.addElement("reset-password").setBoolean(this.resetPassword);
        }
        return xmlElement;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        UserFacts userFacts = null;
        if (object instanceof UserFacts) {
            userFacts = (UserFacts)object;
            bl = userFacts.identifier.equalsIgnoreCase(this.identifier);
        }
        return bl;
    }
}

