/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.services.authentication.facts.objectmodel;

import com.jronimo.collections.MutableSet;
import com.jronimo.messageserver.services.authentication.facts.objectmodel.UserFacts;
import com.jronimo.messageserver.services.authentication.loaders.ServerFactsLoader;
import com.jronimo.messageserver.services.authentication.util.AuthenticationResponseAppender;
import com.jronimo.messageserver.services.authentication.util.UserDetailsValidator;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceFacts {
    private static final Logger logger = Logger.getLogger(ServiceFacts.class);
    private static ServiceFacts instance;
    private File root;
    private File usersXmlFile;
    private long timeoutDuration;
    private Map<Long, UserFacts> usersById;
    private Map<String, UserFacts> usersByName;
    private UserDetailsValidator userDetailsValidator;
    private Collection<AuthenticationResponseAppender> authenticationResponseAppenders = new MutableSet<AuthenticationResponseAppender>(2);

    public ServiceFacts(Details details) {
        this.root = details.root;
        this.usersXmlFile = details.usersXmlFile;
        this.timeoutDuration = details.timeoutDuration;
        this.usersById = details.usersById;
        this.usersByName = details.usersByIdentifier;
        this.userDetailsValidator = details.userDetailsValidator;
        instance = this;
    }

    public static ServiceFacts getInstance() {
        return instance;
    }

    public File getRoot() {
        return this.root;
    }

    public File getUsersXmlFile() {
        return this.usersXmlFile;
    }

    public long getTimeoutDuration() {
        return this.timeoutDuration;
    }

    public void addUser(UserFacts userFacts) {
        this.usersById.put(userFacts.getId(), userFacts);
        this.usersByName.put(userFacts.getIdentifier(), userFacts);
    }

    public Collection<UserFacts> getUsers() {
        return this.usersById.values();
    }

    public UserFacts getUser(Long l) {
        return this.usersById.get(l);
    }

    public UserFacts getUser(String string) {
        return this.usersByName.get(string);
    }

    public boolean hasUser(String string) {
        return this.usersByName.containsKey(string);
    }

    public UserDetailsValidator getUserDetailsValidator() {
        return this.userDetailsValidator;
    }

    public void addAuthenticationResponseAppender(AuthenticationResponseAppender authenticationResponseAppender) {
        this.authenticationResponseAppenders.add(authenticationResponseAppender);
    }

    public Collection<AuthenticationResponseAppender> getAuthenticationResponseAppenders() {
        return this.authenticationResponseAppenders;
    }

    public static synchronized ServiceFacts createInstance(ServletConfig servletConfig, XmlElement xmlElement) {
        return instance == null ? ServerFactsLoader.execute(servletConfig, xmlElement) : instance;
    }

    public static class Details {
        public File root;
        public File usersXmlFile;
        public long timeoutDuration = 20000L;
        public Map<Long, UserFacts> usersById = new HashMap<Long, UserFacts>();
        public Map<String, UserFacts> usersByIdentifier = new HashMap<String, UserFacts>();
        public UserDetailsValidator userDetailsValidator;
    }
}

