/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.services.authentication.facts.active;

import com.jronimo.messageserver.services.authentication.facts.objectmodel.ServiceFacts;
import com.jronimo.messageserver.services.authentication.facts.objectmodel.UserFacts;
import com.jronimo.temporal.DateTime;
import com.jronimo.util.DateUtils;
import com.jronimo.util.Logger;

public class SessionFacts {
    private static final Logger logger = Logger.getLogger(SessionFacts.class);
    private UserFacts user;
    private String id;
    private DateTime expires;

    public SessionFacts(UserFacts userFacts) {
        this.user = userFacts;
        this.id = DateUtils.getUniqueDateTimeString(false);
        this.touch();
    }

    public String getId() {
        return this.id;
    }

    public void setUser(UserFacts userFacts) {
        this.user = userFacts;
    }

    public UserFacts getUser() {
        return this.user;
    }

    public boolean isAuthenticated() {
        return !this.user.isGuest();
    }

    public void touch() {
        this.expires = DateTime.addMilliseconds(DateTime.now(false), ServiceFacts.getInstance().getTimeoutDuration());
    }

    public DateTime getExpires() {
        return this.expires;
    }
}

