/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.services.authentication;

import com.jronimo.messageserver.services.authentication.facts.active.SessionFacts;
import com.jronimo.messageserver.services.authentication.facts.objectmodel.ServiceFacts;
import com.jronimo.messageserver.services.authentication.facts.objectmodel.UserFacts;
import com.jronimo.messageserver.services.authentication.state.Sessions;
import com.jronimo.messageserver.services.authentication.util.AuthenticationResponseAppender;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import java.util.Collection;
import javax.servlet.ServletConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationModel {
    private static final Logger logger = Logger.getLogger(AuthenticationModel.class);
    private static AuthenticationModel instance;
    private UserFacts guestUser;

    private AuthenticationModel(ServletConfig servletConfig, XmlElement xmlElement) {
        ServiceFacts.createInstance(servletConfig, xmlElement);
        this.guestUser = ServiceFacts.getInstance().getUser("Guest");
        instance = this;
    }

    static AuthenticationModel createInstance(ServletConfig servletConfig, XmlElement xmlElement) {
        new AuthenticationModel(servletConfig, xmlElement);
        return instance;
    }

    public static AuthenticationModel getInstance() {
        return instance;
    }

    public SessionFacts getSession(String string) {
        return this.getSession(string, true);
    }

    public SessionFacts getSession(String string, boolean bl) {
        SessionFacts sessionFacts = null;
        sessionFacts = Sessions.getInstance().getSession(string);
        if (bl && sessionFacts != null) {
            sessionFacts.touch();
        }
        return sessionFacts;
    }

    public SessionFacts createGuestSession() {
        SessionFacts sessionFacts = null;
        sessionFacts = new SessionFacts(this.guestUser);
        Sessions.getInstance().addSession(sessionFacts);
        return sessionFacts;
    }

    public SessionFacts createTemporaryGuestSession() {
        return new SessionFacts(this.guestUser);
    }

    public Collection<UserFacts> getUsers() {
        return ServiceFacts.getInstance().getUsers();
    }

    public UserFacts getUser(long l) {
        return ServiceFacts.getInstance().getUser(l);
    }

    public UserFacts getUser(String string) {
        return ServiceFacts.getInstance().getUser(string);
    }

    public void addAuthenticationResponseAppender(AuthenticationResponseAppender authenticationResponseAppender) {
        ServiceFacts.getInstance().addAuthenticationResponseAppender(authenticationResponseAppender);
    }
}

