/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.server.processes;

import com.jronimo.messageserver.server.MessageServer;
import com.jronimo.messageserver.server.facts.active.MessageFacts;
import com.jronimo.messageserver.server.util.Issue;
import com.jronimo.messageserver.server.util.MessageHandlerResult;
import com.jronimo.messageserver.services.authentication.facts.active.SessionFacts;
import com.jronimo.temporal.DateTime;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessRequest {
    private static final Logger logger = Logger.getLogger(ProcessRequest.class);

    private ProcessRequest() {
    }

    public static MessageServer.Result execute(HttpServletRequest httpServletRequest) throws Exception {
        MessageServer.Result result = new MessageServer.Result();
        MessageFacts messageFacts = null;
        MessageHandlerResult messageHandlerResult = null;
        boolean bl = false;
        Set<Issue> set = null;
        XmlElement xmlElement = null;
        boolean bl2 = true;
        result.applyNoCacheHeaders = true;
        if (messageFacts.isValid()) {
            bl = messageHandlerResult.getSuccess();
            if (!bl) {
                set = messageHandlerResult.getIssues();
            }
        } else {
            set = ProcessRequest.assembleIssues(messageFacts);
        }
        if (messageHandlerResult != null && messageHandlerResult.hasRedirect()) {
            result.redirectUrl = messageHandlerResult.getRedirectUrl();
        } else {
            xmlElement = bl ? ProcessRequest.getSuccessMessage(messageHandlerResult) : ProcessRequest.getFailureMessage(set);
            if (messageHandlerResult != null) {
                bl2 = messageHandlerResult.getAppendSessionElement();
            }
            try {
                result.responseBytes = xmlElement.toString().getBytes("UTF-8");
            }
            catch (Exception exception) {
                logger.warning(exception);
            }
            result.contentType = "application/xml";
            if (messageHandlerResult != null) {
                result.responseHeaders = messageHandlerResult.getResponseHeaders();
            }
        }
        return result;
    }

    private static XmlElement getSuccessMessage(MessageHandlerResult messageHandlerResult) {
        XmlElement xmlElement = null;
        xmlElement = ProcessRequest.createMessage(true);
        if (messageHandlerResult.hasResponseMessage()) {
            for (XmlElement xmlElement2 : messageHandlerResult.getResponseMessage().getOptionalElements()) {
                messageHandlerResult.getResponseMessage().removeElement(xmlElement2);
                xmlElement.addElement(xmlElement2);
            }
        }
        return xmlElement;
    }

    private static XmlElement getFailureMessage(Set<Issue> set) {
        XmlElement xmlElement = null;
        XmlElement xmlElement2 = null;
        XmlElement xmlElement3 = null;
        xmlElement = ProcessRequest.createMessage(false);
        xmlElement2 = xmlElement.addElement("issues");
        for (Issue issue : set) {
            xmlElement3 = xmlElement2.addElement("issue");
            xmlElement3.addElement("id").setLong(issue.getId());
            xmlElement3.addElement("message").setText(issue.getMessage());
        }
        return xmlElement;
    }

    private static XmlElement createMessage(boolean bl) {
        XmlElement xmlElement = null;
        xmlElement = XmlElementFactory.create("message");
        xmlElement.addElement("ok").setBoolean(bl);
        return xmlElement;
    }

    private static void appendSession(XmlElement xmlElement, SessionFacts sessionFacts) {
        XmlElement xmlElement2 = null;
        if (sessionFacts != null) {
            xmlElement2 = xmlElement.hasElement("session") ? xmlElement.getElement("session") : xmlElement.addElement("session");
            xmlElement2.addElement("id").setText(sessionFacts.getId());
            xmlElement2.addElement("next-touch").setLong(DateTime.addMinutes(sessionFacts.getExpires(), -1L).getTemporalValue());
            if (!xmlElement.hasElement("user")) {
                xmlElement.addElement(sessionFacts.getUser().getXml(false, false, false, false));
            }
        }
    }

    private static Set<Issue> assembleIssues(MessageFacts messageFacts) {
        HashSet<Issue> hashSet = new HashSet<Issue>(3);
        if (!messageFacts.hasSession()) {
            ProcessRequest.addIssue(Issue.NO_SESSION, hashSet, messageFacts);
        }
        if (!messageFacts.hasMessage()) {
            ProcessRequest.addIssue(Issue.NO_MESSAGE, hashSet, messageFacts);
        }
        return hashSet;
    }

    private static void addIssue(Issue issue, Collection<Issue> collection, MessageFacts messageFacts) {
        collection.add(issue);
        logger.warning("(MessageServer)(URI: " + messageFacts.getRequestUri() + ") " + issue.toString());
    }
}

