/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.server.processes;

import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.messageserver.server.model.RuntimeConfig;
import com.jronimo.messageserver.server.model.SessionConfig;
import com.jronimo.messageserver.util.Constants;
import com.jronimo.messageserver.util.Methods;
import com.jronimo.util.FileMethods;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapper;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrerequisiteTasks {
    private static final Logger logger = Logger.getLogger(PrerequisiteTasks.class);
    private ServletConfig servletConfig;
    private XmlElement configurationSnippetXml;
    private String messageServerName;
    private boolean isMaster;
    private boolean isMinor;
    private String masterAddress;
    private Map<String, String> properties = new HashMap<String, String>(5);
    private File messageServerDirectory;
    private Constants.UserAccountStrategy userAccountStrategy;
    private SessionConfig sessionConfig;
    private RuntimeConfig runtimeConfig;
    private String validationHtml;
    private String signUpValidationMessage;
    private String resetIdentifierValidationMessage;
    private boolean isOwnerPasswordReset;
    private boolean isMessageServerReady;

    private PrerequisiteTasks(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public static PrerequisiteTasks create(ServletConfig servletConfig) {
        return new PrerequisiteTasks(servletConfig).execute();
    }

    public String getMessageServerName() {
        return this.messageServerName;
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public boolean isMinor() {
        return this.isMinor;
    }

    public String getMasterAddress() {
        return this.masterAddress;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public File getMessageServerDirectory() {
        return this.messageServerDirectory;
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public RuntimeConfig getRuntimeConfig() {
        return this.runtimeConfig;
    }

    public String getValidationHtml() {
        return this.validationHtml;
    }

    public String getSignUpValidationMessage() {
        return this.signUpValidationMessage;
    }

    public String getResetIdentifierValidationMessage() {
        return this.resetIdentifierValidationMessage;
    }

    public boolean isOwnerPasswordReset() {
        return this.isOwnerPasswordReset;
    }

    public boolean isMessageServerReady() {
        return this.isMessageServerReady;
    }

    private PrerequisiteTasks execute() {
        try {
            this.configurationSnippetXml = XmlElementFactory.load(Methods.readInitParameterXmlSnippet(this.servletConfig, "messageServerConfig"));
            this.messageServerName = this.configurationSnippetXml.getText("name");
            logger.info("Message Server: " + this.messageServerName);
            this.isMaster = this.configurationSnippetXml.getBoolean("is-master");
            this.isMinor = this.configurationSnippetXml.getBoolean("is-minor");
            this.masterAddress = this.configurationSnippetXml.getOptionalText("master-address");
            this.extractProperties();
            this.userAccountStrategy = Constants.UserAccountStrategy.match(this.configurationSnippetXml.getText("user-account-strategy"));
            if (this.isMinor) {
                this.sessionConfig = new SessionConfig(this.configurationSnippetXml.getElement("session-config"));
            }
            this.messageServerDirectory = new File((File)this.servletConfig.getServletContext().getAttribute("javax.servlet.context.tempdir"), "MessageServer/" + this.messageServerName);
            this.checkDirectories();
            this.checkRuntimeConfigurationFile();
            this.checkUserAccounts();
            this.checkOwnerPassword();
            if (this.isMaster) {
                this.validationHtml = this.retrieveValidationHtml();
                this.signUpValidationMessage = this.retrieveValidationMessage("validation-message-sign-up");
                this.resetIdentifierValidationMessage = this.retrieveValidationMessage("validation-message-reset-identifier");
            }
            this.isMessageServerReady = this.isMaster ? this.isOwnerPasswordReset && !Methods.isEmpty(this.validationHtml) && !Methods.isEmpty(this.signUpValidationMessage) : true;
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
        return this;
    }

    private void extractProperties() {
        for (XmlElement xmlElement : this.configurationSnippetXml.getOptionalElements("properties/property")) {
            this.properties.put(xmlElement.getText("name"), xmlElement.getText("value"));
        }
    }

    private void checkDirectories() {
        File file = null;
        File file2 = null;
        File file3 = null;
        File file4 = null;
        this.messageServerDirectory.mkdirs();
        file = new File(this.messageServerDirectory, "users");
        file.mkdirs();
        file2 = new File(this.messageServerDirectory, "roles");
        file2.mkdirs();
        file3 = new File(this.messageServerDirectory, "temp");
        file3.mkdirs();
        FileMethods.deleteFolderContents(file3, false);
        file4 = new File(this.messageServerDirectory, "store");
        file4.mkdirs();
    }

    private void checkRuntimeConfigurationFile() {
        String string = null;
        File file = null;
        XmlElement xmlElement = null;
        file = new File(this.messageServerDirectory, "MessageServer.xml");
        if (!file.exists()) {
            string = "/com/jronimo/messageserver/server/templates/MessageServer.xml";
            xmlElement = XmlElementFactory.load(this.getClass().getResource(string));
            if (this.userAccountStrategy.isUser()) {
                xmlElement.getElement("user-account-strategy").setText("user");
            }
            xmlElement.save(file);
        }
        this.runtimeConfig = new RuntimeConfig(file);
        this.userAccountStrategy = this.runtimeConfig.getUserAccountStrategy();
    }

    private void checkUserAccounts() {
        if (this.isMaster) {
            this.checkUserAccount(UserAccountType.OWNER);
            this.checkUserAccount(UserAccountType.GUEST);
        }
    }

    private void checkUserAccount(UserAccountType userAccountType) {
        String string = null;
        File file = null;
        XmlElement xmlElement = null;
        file = new File(this.messageServerDirectory, "users/" + userAccountType.getTargetFilename());
        if (!file.exists()) {
            string = "com/jronimo/messageserver/server/templates/" + userAccountType.getSourceFilename();
            xmlElement = XmlElementFactory.load(this.getClass().getClassLoader().getResource(string));
            if (this.userAccountStrategy.isUser()) {
                xmlElement.addElement("validated").setBoolean(true);
            }
            xmlElement.save(file);
        }
    }

    private void checkOwnerPassword() {
        XmlElement xmlElement = null;
        if (this.isMaster) {
            xmlElement = XmlElementFactory.load(new File(this.messageServerDirectory, "users/0.xml"));
            boolean bl = this.isOwnerPasswordReset = !xmlElement.getText("pass").equals("2b10dfd2e4c3ab334c8814a1f65dc7c1");
            if (!this.isOwnerPasswordReset) {
                logger.warning("The owner user account for the Message Server instance (" + this.messageServerName + ") has not had its password value reset from the default value.");
            }
        } else {
            this.isOwnerPasswordReset = true;
        }
    }

    private String retrieveValidationHtml() {
        String string = null;
        String string2 = null;
        try {
            string2 = "com/jronimo/messageserver/server/templates/ValidationHtml.txt";
            string = FileMethods.readTextFile(this.getClass().getClassLoader().getResource(string2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Methods.isEmpty(string)) {
            logger.error("The validation HTML could not be retrieved.");
        }
        return string;
    }

    private String retrieveValidationMessage(String string) {
        String string2 = null;
        String string3 = null;
        StringWrapper stringWrapper = null;
        int n = 0;
        Class<?> clazz = null;
        Method method = null;
        try {
            string3 = this.properties.get(string);
            if (!Methods.isEmpty(string3)) {
                stringWrapper = new StringWrapper(string3);
                n = stringWrapper.lastIndexOf(".");
                clazz = Class.forName(stringWrapper.before(n));
                method = clazz.getMethod(stringWrapper.after(n), new Class[0]);
                string2 = (String)method.invoke(null, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Methods.isEmpty(string2)) {
            logger.error("There was an issue retrieving a validation message: name(" + string + ") value(" + string3 + ")");
        }
        return string2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UserAccountType {
        OWNER("owner.xml", "0.xml"),
        GUEST("guest.xml", "1.xml");

        private String sourceFilename;
        private String targetFilename;

        private UserAccountType(String string2, String string3) {
            this.sourceFilename = string2;
            this.targetFilename = string3;
        }

        public boolean isOwner() {
            return this == OWNER;
        }

        public boolean isGuest() {
            return this == GUEST;
        }

        public String getSourceFilename() {
            return this.sourceFilename;
        }

        public String getTargetFilename() {
            return this.targetFilename;
        }
    }
}

