/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.server.model;

import com.jronimo.messageserver.server.facts.objectmodel.ServerFacts;
import com.jronimo.messageserver.util.Methods;
import com.jronimo.temporal.DateTime;
import com.jronimo.util.Logger;
import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.io.File;

public final class UserAccount {
    private static final Logger logger = Logger.getLogger(UserAccount.class);
    private long id;
    private String identifier;
    private String pass;
    private String displayName;
    private boolean resetPassword;
    private ValidationDetails validationDetails;

    UserAccount(long l, String string, String string2, String string3, boolean bl, ValidationDetails validationDetails) {
        this(l, string, string2, string3, bl, validationDetails, true);
    }

    private UserAccount(long l, String string, String string2, String string3, boolean bl, ValidationDetails validationDetails, boolean bl2) {
        this.id = l;
        this.identifier = string;
        this.pass = bl2 ? Methods.hashPass(string2) : string2;
        this.displayName = string3;
        this.resetPassword = bl;
        this.validationDetails = validationDetails;
    }

    public long getId() {
        return this.id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean hasPass(String string) {
        return this.pass.equals(Methods.hashPass(string));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean getResetPassword() {
        return this.resetPassword;
    }

    public boolean hasValidationDetails() {
        return this.validationDetails != null;
    }

    public ValidationDetails getValidationDetails() {
        return this.validationDetails;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        UserAccount userAccount = null;
        if (object instanceof UserAccount) {
            userAccount = (UserAccount)object;
            bl = this.id == userAccount.id;
        }
        return bl;
    }

    public String toString() {
        return this.id + ":" + this.identifier;
    }

    public boolean isValidated() {
        return this.validationDetails == null;
    }

    public void setValues(ServerFacts serverFacts, Struct struct) {
        if (!Methods.isEmpty(struct.identifier)) {
            this.identifier = struct.identifier;
        }
        if (!Methods.isEmpty(struct.pass)) {
            this.pass = Methods.hashPass(struct.pass);
        }
        if (!Methods.isEmpty(struct.displayName)) {
            this.displayName = struct.displayName;
        }
        if (struct.resetPassword != null) {
            this.resetPassword = struct.resetPassword;
        }
        if (struct.requiresValidation) {
            this.validationDetails = new ValidationDetails();
        }
        this.save(serverFacts);
    }

    public boolean validateByPin(ServerFacts serverFacts, String string) {
        boolean bl = true;
        if (!this.isValidated()) {
            if (this.validationDetails.hasPin(string)) {
                this.validationDetails = null;
                this.save(serverFacts);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public boolean validateByKey(ServerFacts serverFacts, String string) {
        boolean bl = true;
        if (!this.isValidated()) {
            if (this.validationDetails.hasKey(string)) {
                this.validationDetails = null;
                this.save(serverFacts);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public void save(ServerFacts serverFacts) {
        File file = new File(serverFacts.getMessageServerDirectory("users"), this.id + ".xml");
        XmlElement xmlElement = XmlElementFactory.create("user-account");
        xmlElement.addElement("id").setLong(this.id);
        xmlElement.addElement("identifier").setText(this.identifier);
        xmlElement.addElement("pass").setText(this.pass);
        xmlElement.addElement("display-name").setText(this.displayName);
        if (this.resetPassword) {
            xmlElement.addElement("reset-password").setBoolean(this.resetPassword);
        }
        xmlElement.addElement("validated").setBoolean(this.isValidated());
        if (this.validationDetails != null) {
            xmlElement.addElement("validation-pin").setText(this.validationDetails.getPin());
            xmlElement.addElement("validation-key").setText(this.validationDetails.getKey());
            xmlElement.addElement("validation-expiry").setDateTime(this.validationDetails.getExpiry());
        }
        xmlElement.save(file);
    }

    public static UserAccount load(XmlElement xmlElement) {
        boolean bl = xmlElement.getOptionalBoolean("validated", "true");
        UserAccount userAccount = null;
        ValidationDetails validationDetails = null;
        if (!bl) {
            validationDetails = new ValidationDetails(xmlElement.getText("validation-pin"), xmlElement.getText("validation-key"), xmlElement.getDateTime("validation-expiry"));
        }
        userAccount = new UserAccount(xmlElement.getLong("id"), xmlElement.getText("identifier"), xmlElement.getText("pass"), xmlElement.getText("display-name"), xmlElement.getOptionalBoolean("reset-password", "false"), validationDetails, false);
        return userAccount;
    }

    public static class ValidationDetails {
        public String pin;
        public String key;
        public DateTime expiry;

        ValidationDetails() {
            this.pin = Methods.getRandomString(6, "0123456789");
            this.key = Methods.getRandomString(40);
            this.expiry = DateTime.addDays(DateTime.now(0), 2);
        }

        private ValidationDetails(String string, String string2, DateTime dateTime) {
            this.pin = string;
            this.key = string2;
            this.expiry = dateTime;
        }

        public String getPin() {
            return this.pin;
        }

        public String getKey() {
            return this.key;
        }

        public DateTime getExpiry() {
            return this.expiry;
        }

        public boolean hasPin(String string) {
            return string != null && string.equals(this.pin);
        }

        public boolean hasKey(String string) {
            return string != null && string.equals(this.key);
        }

        public boolean hasExpired(DateTime dateTime) {
            return this.expiry.lessThan(dateTime, true);
        }
    }

    public static class Struct {
        public long id;
        public String identifier;
        public String pass;
        public String displayName;
        public Boolean resetPassword;
        public boolean requiresValidation;
    }
}

