/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.server.model;

import com.jronimo.collections.NullFreeMutableList;
import com.jronimo.collections.collection.types.nullfree.NullFreeMutableCollection;
import com.jronimo.messageserver.server.model.SessionConfig;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import com.jronimo.util.StringWrapper;

public class Session {
    private static final Logger logger = Logger.getLogger(Session.class);
    private SessionConfig sessionConfig;
    private int userId;
    private String id;
    private NullFreeMutableCollection<String> interactionIds;
    private NullFreeMutableCollection<String> topUps = new NullFreeMutableList<String>();

    public Session(SessionConfig sessionConfig, int n, String string) {
        this.sessionConfig = sessionConfig;
        this.userId = n;
        this.id = string;
        this.interactionIds = new NullFreeMutableList<String>(this.sessionConfig.getInteractionIds().getTotal());
        this.topUp();
    }

    public String getId() {
        return this.id;
    }

    public int getUserId() {
        return this.userId;
    }

    public synchronized boolean validateInteractionIds(String string) {
        boolean bl = false;
        NullFreeMutableList<String> nullFreeMutableList = null;
        int n = 0;
        if (Methods.isEmpty(string)) {
            bl = true;
            nullFreeMutableList = new StringWrapper(string).split(",", true);
            for (String string2 : nullFreeMutableList) {
                n = this.interactionIds.indexOf(string2);
                if (n >= 0) {
                    this.interactionIds.remove(n);
                    continue;
                }
                bl = false;
                break;
            }
        }
        return bl;
    }

    public synchronized String getTopUp() {
        String string = null;
        this.topUp();
        if (!this.topUps.isEmpty()) {
            string = (String)this.topUps.getFirst();
            this.topUps.removeFirst();
        }
        return string;
    }

    private synchronized void topUp() {
        StringWrapper stringWrapper = null;
        int n = 0;
        String string = null;
        if (this.interactionIds.size() < this.sessionConfig.getInteractionIds().getTotal() / 2) {
            stringWrapper = new StringWrapper();
            n = this.sessionConfig.getInteractionIds().getTotal() - this.interactionIds.size();
            for (int i = 1; i <= n; ++i) {
                string = Methods.getRandomString(this.sessionConfig.getInteractionIds().getLength());
                this.interactionIds.add(string);
                stringWrapper.append(string).append(",");
            }
            stringWrapper.deleteLast(stringWrapper.endsWith(","));
            this.topUps.add(stringWrapper.toString());
        }
    }
}

