/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.server.model;

import com.jronimo.messageserver.util.Methods;
import com.jronimo.util.Logger;

public class Issue {
    private static final Logger logger = Logger.getLogger(Issue.class);
    public static final Issue NO_MESSAGE = new Issue(Scope.SERVER, "NO_MESSAGE");
    public static final Issue UNRECOGNIZED_TARGET = new Issue(Scope.SERVER, "UNRECOGNIZED_TARGET");
    public static final Issue INACTIVE_ACTION = new Issue(Scope.SERVER, "INACTIVE_ACTION");
    public static final Issue NO_SESSION = new Issue(Scope.SERVER, "NO_SESSION");
    public static final Issue NO_DETAILS = new Issue(Scope.ACTION, "NO_DETAILS");
    public static final Issue INCOMPLETE_DETAILS = new Issue(Scope.ACTION, "INCOMPLETE_DETAILS");
    public static final Issue NOT_FOUND = new Issue(Scope.ACTION, "NOT_FOUND");
    public static final Issue ALREADY_EXISTS = new Issue(Scope.ACTION, "ALREADY_EXISTS");
    public static final Issue NO_CHANGE = new Issue(Scope.ACTION, "NO_CHANGE");
    public static final Issue UNEXPECTED_STATE = new Issue(Scope.ACTION, "UNEXPECTED_STATE");
    private Scope scope;
    private String code;
    private String description;

    public Issue(String string) {
        this(Scope.ACTION, string);
    }

    public Issue(Scope scope, String string) {
        this(scope, string, null);
    }

    public Issue(Scope scope, String string, String string2) {
        this.scope = scope;
        this.code = string;
        this.description = string2;
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getCode() {
        return this.code;
    }

    public Issue setDescription(String string) {
        this.description = string;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasDescription() {
        return !Methods.isEmpty(this.description);
    }

    public int hashCode() {
        int n = 17;
        n = n * 37 + this.scope.toString().hashCode();
        n = n * 37 + this.code.hashCode();
        if (this.description != null) {
            n = n * 37 + this.description.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        Issue issue = null;
        if (object instanceof Issue) {
            issue = (Issue)object;
            bl = Methods.bothEqual((Object)this.scope, (Object)issue.scope) && Methods.bothEqual(this.code, issue.code) && Methods.bothEqual(this.description, issue.description);
        }
        return bl;
    }

    public String toString() {
        return this.code;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Scope {
        SERVER,
        ACTION;

    }
}

