/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.messageserver.server;

import com.jronimo.messageserver.server.facts.objectmodel.ServerFacts;
import com.jronimo.messageserver.server.processes.PrerequisiteTasks;
import com.jronimo.messageserver.server.processes.ProcessMessage;
import com.jronimo.messageserver.server.processes.ShowValidationMessage;
import com.jronimo.messageserver.server.processes.Validate;
import com.jronimo.messageserver.util.Methods;
import com.jronimo.util.Logger;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MessageServer
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(MessageServer.class);
    private boolean supportPing;
    private String pingOrigins;
    private boolean messageServerReady;
    private String notReadyMessage;
    private ServerFacts serverFacts;

    public void init(ServletConfig servletConfig) throws ServletException {
        PrerequisiteTasks prerequisiteTasks = null;
        logger.info("Start: Init for MessageServer...");
        this.supportPing = Boolean.valueOf(servletConfig.getInitParameter("supportPing"));
        if (this.supportPing) {
            this.pingOrigins = servletConfig.getInitParameter("pingOrigins");
        }
        try {
            prerequisiteTasks = PrerequisiteTasks.create(servletConfig);
            this.messageServerReady = prerequisiteTasks.isMessageServerReady();
            if (this.messageServerReady) {
                this.serverFacts = ServerFacts.createInstance(servletConfig, prerequisiteTasks);
                logger.info("Message Server ready: " + this.serverFacts.getMessageServerName());
            } else {
                this.notReadyMessage = !prerequisiteTasks.isOwnerPasswordReset() ? "The Message Server (" + prerequisiteTasks.getMessageServerName() + ") is not ready because the password for the owner user account has not been reset from its" + " default value." : "The Message Server (" + prerequisiteTasks.getMessageServerName() + ") is not ready.";
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        logger.info("End: Init for MessageServer.");
    }

    public void doHead(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        if (this.supportPing && Methods.getString(httpServletRequest.getPathInfo()).endsWith("/ping")) {
            this.processPing(httpServletResponse);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        if (this.supportPing && Methods.getString(httpServletRequest.getPathInfo()).endsWith("/ping")) {
            this.processPing(httpServletResponse);
        } else {
            this.processRequest(httpServletRequest, httpServletResponse);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    private void processPing(HttpServletResponse httpServletResponse) throws ServletException {
        httpServletResponse.setHeader("Access-Control-Allow-Origin", this.pingOrigins);
        try {
            httpServletResponse.getOutputStream().flush();
        }
        catch (Exception exception) {
            logger.error(exception);
        }
    }

    private void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Result result = null;
        String string = null;
        try {
            if (this.messageServerReady) {
                if (httpServletRequest.getMethod().equalsIgnoreCase("post")) {
                    result = ProcessMessage.execute(this.serverFacts, httpServletRequest);
                } else if (httpServletRequest.getMethod().equalsIgnoreCase("get")) {
                    string = httpServletRequest.getParameter("target");
                    if ("validate".equals(string)) {
                        result = Validate.execute(this.serverFacts, httpServletRequest);
                    } else if ("validationSuccessful".equals(string)) {
                        result = ShowValidationMessage.execute(this.serverFacts, true);
                    } else if ("validationNotSuccessful".equals(string)) {
                        result = ShowValidationMessage.execute(this.serverFacts, false);
                    }
                }
                if (result == null) {
                    Methods.applyHeaders(httpServletResponse, null, true, null);
                    httpServletResponse.setStatus(500);
                } else if (result.redirectUrl == null) {
                    Methods.applyHeaders(httpServletResponse, result.contentType, result.applyNoCacheHeaders, result.responseHeaders);
                    if (result.responseBytes == null) {
                        httpServletResponse.setStatus(500);
                    } else {
                        httpServletResponse.getOutputStream().write(result.responseBytes);
                    }
                } else {
                    httpServletResponse.sendRedirect(result.redirectUrl);
                }
            } else {
                logger.error(this.notReadyMessage);
                httpServletResponse.getOutputStream().write(this.notReadyMessage.getBytes());
                httpServletResponse.setStatus(500);
            }
        }
        catch (Throwable throwable) {
            logger.error(throwable);
        }
        try {
            httpServletResponse.getOutputStream().flush();
        }
        catch (Exception exception) {
            logger.error(exception);
        }
    }

    public void destroy() {
        try {
            super.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class Result {
        public byte[] responseBytes;
        public String contentType;
        public boolean applyNoCacheHeaders;
        public Map<String, String> responseHeaders;
        public String redirectUrl;
    }
}

