/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.internationalization;

import com.jronimo.collections.NullFreeImmutableSet;
import com.jronimo.internationalization.Languages;
import com.jronimo.util.Logger;
import java.util.Locale;
import java.util.Set;

public class Language {
    private static final Logger logger = Logger.getLogger(Language.class);
    private String languageCode;
    private String variation;
    private boolean isDefaultVariation;
    private Set<String> countryCodes;

    Language(String string) {
        this.languageCode = string;
    }

    Language(String string, String string2, String[] stringArray) {
        this.languageCode = string;
        this.variation = string2;
        this.countryCodes = new NullFreeImmutableSet<String>(stringArray);
    }

    Language(String string, String string2, boolean bl) {
        this.languageCode = string;
        this.variation = string2;
        this.isDefaultVariation = bl;
    }

    public boolean isVariation() {
        return this.variation != null;
    }

    public Language getPrimaryLanguage() {
        return Languages.getInstance().getPrimary(this.languageCode);
    }

    public boolean isDefaultVariation(Locale locale) {
        boolean bl = false;
        bl = this.languageCode.equals(locale.getLanguage()) && this.isDefaultVariation;
        return bl;
    }

    public boolean matches(Locale locale) {
        boolean bl = false;
        bl = this.languageCode.equals(locale.getLanguage());
        if (bl && this.countryCodes != null) {
            bl = this.countryCodes.contains(locale.getCountry());
        }
        return bl;
    }

    public boolean isDefaultVariation(String string) {
        return this.languageCode.equals(string) && this.isDefaultVariation;
    }

    public boolean matches(String string) {
        return this.matches(string, null);
    }

    public boolean matches(String string, String string2) {
        boolean bl = false;
        bl = this.languageCode.equals(string);
        if (bl && this.variation != null) {
            bl = this.variation.equals(string2);
        }
        return bl;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        Language language = null;
        if (object instanceof Language && (language = (Language)object).toString().equals(this.toString())) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        return this.languageCode + (this.variation == null ? "" : "_" + this.variation);
    }
}

