/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.http;

import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.http.exceptions.ReadTimedOutException;
import com.jronimo.http.exceptions.StreamBytesNotFoundException;
import com.jronimo.util.Logger;
import com.jronimo.webappengines.core.Methods;
import java.io.InputStream;
import java.util.ArrayList;

public final class StreamReader
extends Thread {
    private static final Logger logger = Logger.getLogger(StreamReader.class);
    private InputStream inputStream;
    private ConfigStruct configStruct;
    private Long readTime;
    private Integer readLength;
    private byte[] bytes;
    private Exception exception;

    public StreamReader(InputStream inputStream) {
        this(inputStream, new ConfigStruct());
    }

    public StreamReader(InputStream inputStream, ConfigStruct configStruct) {
        this.inputStream = inputStream;
        this.configStruct = configStruct;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public Exception getException() {
        return this.exception;
    }

    public Long getReadTime() {
        return this.readTime;
    }

    public Integer getReadLength() {
        return this.readLength;
    }

    public void run() {
        try {
            this.readBytes();
        }
        catch (Exception exception) {
            this.exception = exception;
        }
    }

    private void readBytes() {
        ReadThread readThread = null;
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        long l3 = 0L;
        if (this.configStruct.numberOfBytesToRead == null) {
            readThread = new ReadThreadUnknownQuantity(this.inputStream);
        } else {
            n = Math.max(this.configStruct.minReadTimeout, (int)Math.ceil(1000 * (this.configStruct.numberOfBytesToRead / this.configStruct.bytesPerSecond)));
            readThread = new ReadThreadKnownQuantity(this.inputStream, this.configStruct.numberOfBytesToRead);
        }
        new Thread(readThread).start();
        l = System.currentTimeMillis();
        Methods.sleep(this.configStruct.initialDelay);
        while (!readThread.isFinished() && (l3 += (long)this.configStruct.readSleepInterval) <= (long)n) {
            Methods.sleep(this.configStruct.readSleepInterval);
        }
        l2 = System.currentTimeMillis() - l;
        if (readThread.hasException()) {
            throw new UnexpectedErrorException(readThread.getException());
        }
        if (!readThread.isFinished()) {
            throw new ReadTimedOutException(n);
        }
        if (readThread.getNumberOfBytesRead() != this.configStruct.numberOfBytesToRead.intValue()) {
            throw new StreamBytesNotFoundException(this.configStruct.numberOfBytesToRead, readThread.getNumberOfBytesRead());
        }
        this.bytes = readThread.getBytes();
        this.readTime = l2;
        this.readLength = this.bytes.length;
    }

    public static final class ConfigStruct {
        public Integer numberOfBytesToRead;
        public int initialDelay = 10;
        public int readSleepInterval = 100;
        public int bytesPerSecond = 3400;
        public int minReadTimeout = 10000;
    }

    private static interface ReadThread
    extends Runnable {
        public boolean isFinished();

        public boolean hasException();

        public Throwable getException();

        public int getNumberOfBytesRead();

        public byte[] getBytes();
    }

    private final class ReadThreadKnownQuantity
    implements ReadThread {
        private InputStream inputStream = null;
        private byte[] bytes = null;
        private int numberOfBytesRead = 0;
        private boolean finished = false;
        private Throwable exception;

        protected ReadThreadKnownQuantity(InputStream inputStream, int n) {
            this.inputStream = inputStream;
            this.bytes = new byte[n];
        }

        public void run() {
            int n = 0;
            try {
                while (this.numberOfBytesRead < this.bytes.length && n >= 0) {
                    n = this.inputStream.read(this.bytes, this.numberOfBytesRead, this.bytes.length - this.numberOfBytesRead);
                    if (n < 0) continue;
                    this.numberOfBytesRead += n;
                }
                this.finished = true;
            }
            catch (Throwable throwable) {
                this.exception = throwable;
            }
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean hasException() {
            return this.exception != null;
        }

        public Throwable getException() {
            return this.exception;
        }

        public int getNumberOfBytesRead() {
            return this.numberOfBytesRead;
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }

    private final class ReadThreadUnknownQuantity
    implements ReadThread {
        private InputStream inputStream = null;
        private byte[] bytes = null;
        private int numberOfBytesRead = 0;
        private boolean finished = false;
        private Throwable exception;

        protected ReadThreadUnknownQuantity(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public void run() {
            byte[] byArray = null;
            ArrayList<Byte> arrayList = null;
            int n = 0;
            int n2 = 0;
            byArray = new byte[1024];
            arrayList = new ArrayList<Byte>(1024);
            try {
                while ((n = this.inputStream.read(byArray)) >= 0) {
                    this.numberOfBytesRead += n;
                    int n3 = n;
                    for (int i = 0; i < n3; ++i) {
                        arrayList.add(byArray[i]);
                    }
                }
                this.bytes = new byte[arrayList.size()];
                for (Byte by : arrayList) {
                    this.bytes[n2++] = by;
                }
                this.finished = true;
            }
            catch (Throwable throwable) {
                this.exception = throwable;
            }
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean hasException() {
            return this.exception != null;
        }

        public Throwable getException() {
            return this.exception;
        }

        public int getNumberOfBytesRead() {
            return this.numberOfBytesRead;
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

