/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.http;

import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapper;
import java.util.HashMap;
import java.util.Map;

public class MimeTypes {
    private static final Logger logger = Logger.getLogger(MimeTypes.class);
    private final Map<String, String> mimeTypes = new HashMap<String, String>(14);
    private static final MimeTypes instance = new MimeTypes();

    private MimeTypes() {
        this.mimeTypes.put(".txt", "text/plain");
        this.mimeTypes.put(".html", "text/html");
        this.mimeTypes.put(".css", "text/css");
        this.mimeTypes.put(".appcache", "text/cache-manifest");
        this.mimeTypes.put(".js", "application/javascript");
        this.mimeTypes.put(".xml", "application/xml");
        this.mimeTypes.put(".zip", "application/zip");
        this.mimeTypes.put(".png", "image/png");
        this.mimeTypes.put(".gif", "image/gif");
        this.mimeTypes.put(".png", "image/png");
        this.mimeTypes.put(".ico", "image/x-icon");
        this.mimeTypes.put(".jpg", "image/jpeg");
        this.mimeTypes.put(".jpe", "image/jpeg");
        this.mimeTypes.put(".jpeg", "image/jpeg");
        this.mimeTypes.put(".pdf", "application/pdf");
    }

    public static MimeTypes getInstance() {
        return instance;
    }

    public String getMimeType(String string) {
        return this.mimeTypes.get(new StringWrapper(string).fromLast(".", false));
    }

    public void addMimeType(String string, String string2) {
        this.mimeTypes.put(string, string2);
    }
}

