/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.http;

import com.jronimo.http.AbstractHttp;
import com.jronimo.http.UrlParts;
import com.jronimo.util.Logger;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;

public final class HttpPost
extends AbstractHttp {
    private static final Logger logger = Logger.getLogger(HttpPost.class);
    private HttpStruct httpStruct;
    private byte[] bytesToSend;

    public HttpPost(UrlParts urlParts, byte[] byArray) {
        this(urlParts, new HttpStruct(), byArray);
    }

    public HttpPost(UrlParts urlParts, HttpStruct httpStruct, byte[] byArray) {
        super(urlParts);
        this.httpStruct = httpStruct;
        this.bytesToSend = byArray;
    }

    protected void configureConnection(HttpURLConnection httpURLConnection) throws Exception {
        httpURLConnection.setConnectTimeout(this.httpStruct.connectionTimeout);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(this.httpStruct.useCaches);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("content-type", this.httpStruct.contentType + this.httpStruct.charset);
        httpURLConnection.setRequestProperty("content-length", String.valueOf(this.bytesToSend.length));
    }

    protected void sendRequest(HttpURLConnection httpURLConnection) throws Exception {
        BufferedOutputStream bufferedOutputStream = null;
        bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
        ((OutputStream)bufferedOutputStream).write(this.bytesToSend);
        ((OutputStream)bufferedOutputStream).flush();
    }

    public static final class HttpStruct {
        public int connectionTimeout = 10000;
        public String contentType = "text/xml;";
        public String charset = "UTF-8";
        public boolean useCaches = false;
    }
}

