/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.exceptions;

import com.jronimo.xml.XmlElement;
import com.jronimo.xml.XmlElementFactory;
import java.sql.Timestamp;

public abstract class BaseRuntimeException
extends RuntimeException {
    protected String message;
    private long timestamp = 0L;

    public BaseRuntimeException(String string) {
        this.message = string;
        this.timestamp = System.currentTimeMillis();
    }

    public BaseRuntimeException(Throwable throwable) {
        super(throwable);
        this.timestamp = System.currentTimeMillis();
    }

    public BaseRuntimeException(String string, Throwable throwable) {
        super(throwable);
        this.message = string;
        this.timestamp = System.currentTimeMillis();
    }

    protected BaseRuntimeException() {
    }

    public String getMessage() {
        return this.message;
    }

    protected static String getTitle(Class clazz) {
        return clazz.getSimpleName();
    }

    public Timestamp getTimestamp() {
        Timestamp timestamp = null;
        timestamp = new Timestamp(this.timestamp);
        return timestamp;
    }

    public XmlElement getXml() {
        XmlElement xmlElement = null;
        xmlElement = XmlElementFactory.create("exception");
        xmlElement.addElement("type").setText(this.getClass().getSimpleName());
        xmlElement.addElement("message").setText(this.getMessage());
        return xmlElement;
    }
}

