/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dbrep;

import com.jronimo.engines.dbrep.Field;
import com.jronimo.engines.dbrep.FieldValue;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Results {
    private static final Logger logger = Logger.getLogger(Results.class);
    private List<Result> list;

    public Results(ResultSet resultSet, List<Field> list) {
        try {
            this.list = new ArrayList<Result>();
            while (resultSet.next()) {
                this.list.add(this.loadRecord(resultSet, list));
            }
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
    }

    public Result get(int n) {
        return this.list.get(n);
    }

    public int size() {
        return this.list.size();
    }

    private Result loadRecord(ResultSet resultSet, List<Field> list) throws Exception {
        Class[] classArray = new Class[]{String.class};
        Result result = null;
        Field field = null;
        String string = null;
        String string2 = null;
        Object object = null;
        result = new Result(list.size());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            field = list.get(i);
            string = field.getType().getJavaType();
            string2 = string;
            if (string2.equals("Integer")) {
                string2 = "Int";
            } else if (string2.equals("byte[]")) {
                string2 = "Bytes";
            } else if (string2.equals("DateTime")) {
                string2 = "Timestamp";
            }
            string2 = "get" + string2;
            object = Methods.executeViaReflection(ResultSet.class, (Object)resultSet, string2, true, classArray, (Object[])new String[]{field.getUpperCaseName()});
            if (resultSet.wasNull()) {
                object = null;
            }
            result.add(field.getUpperCaseName(), new FieldValue(field, object));
        }
        return result;
    }

    public static class Result {
        private Map<String, FieldValue> values;

        private Result(int n) {
            this.values = new HashMap<String, FieldValue>(n);
        }

        private void add(String string, FieldValue fieldValue) {
            this.values.put(string, fieldValue);
        }

        public Boolean getBoolean(String string) {
            return this.values.get(string).getBoolean();
        }

        public Byte getByte(String string) {
            return this.values.get(string).getByte();
        }

        public Short getShort(String string) {
            return this.values.get(string).getShort();
        }

        public Integer getInteger(String string) {
            return this.values.get(string).getInteger();
        }

        public Long getLong(String string) {
            return this.values.get(string).getLong();
        }

        public Float getFloat(String string) {
            return this.values.get(string).getFloat();
        }

        public Double getDouble(String string) {
            return this.values.get(string).getDouble();
        }

        public String getString(String string) {
            return this.values.get(string).getString();
        }

        public byte[] getBytes(String string) {
            return this.values.get(string).getBytes();
        }
    }
}

