/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dbrep;

import com.jronimo.collections.NullFreeMutableList;
import com.jronimo.engines.dbrep.ConnectionProviderGenerator;
import com.jronimo.engines.dbrep.EntityGenerator;
import com.jronimo.engines.dbrep.GenerationConfig;
import com.jronimo.engines.dbrep.GenerationConfigReader;
import com.jronimo.engines.dbrep.Table;
import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.util.FileMethods;
import com.jronimo.util.Logger;
import com.jronimo.util.StringWrapperWithVoidRegions;
import java.io.File;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Generator {
    private static final Logger logger = Logger.getLogger(Generator.class);
    public static final String CREATE_TABLE = "Create Table ";
    private File generationRoot;
    private GenerationConfig generationConfig = null;

    public Generator(File file, File file2) {
        try {
            this.generationConfig = new GenerationConfigReader(file2).read();
            this.generationRoot = new File(file, this.generationConfig.getName());
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
    }

    public void generate() throws Exception {
        NullFreeMutableList<Table> nullFreeMutableList = null;
        File file = null;
        ConnectionProviderGenerator.Struct struct = null;
        EntityGenerator.Struct struct2 = null;
        nullFreeMutableList = new NullFreeMutableList<Table>();
        for (String string : this.readFiles()) {
            nullFreeMutableList.addAll(this.getTables(string));
        }
        file = new File(this.generationRoot, "src/" + this.generationConfig.getPackageString().replace('.', '/'));
        file.mkdirs();
        FileMethods.deleteFolderContents(file, false);
        struct = new ConnectionProviderGenerator.Struct();
        struct.generationRoot = this.generationRoot;
        struct.config = this.generationConfig;
        new ConnectionProviderGenerator(struct).execute();
        struct2 = new EntityGenerator.Struct();
        struct2.generationRoot = this.generationRoot;
        struct2.srcDirectory = file;
        struct2.config = this.generationConfig;
        Iterator iterator = nullFreeMutableList.iterator();
        while (iterator.hasNext()) {
            Table table;
            struct2.table = table = (Table)iterator.next();
            new EntityGenerator(struct2).execute();
        }
        this.copyToSrcLocations(struct2.srcDirectory);
    }

    private String[] readFiles() throws Exception {
        String[] stringArray = null;
        File[] fileArray = null;
        boolean bl = false;
        fileArray = this.generationConfig.getFiles();
        stringArray = new String[fileArray.length];
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = FileMethods.readTextFile(fileArray[i]);
            stringArray[i] = stringArray[i].substring(stringArray[i].indexOf(CREATE_TABLE));
        }
        return stringArray;
    }

    private NullFreeMutableList<Table> getTables(String string) throws Exception {
        NullFreeMutableList<Table> nullFreeMutableList = null;
        NullFreeMutableList<String> nullFreeMutableList2 = null;
        nullFreeMutableList = new NullFreeMutableList<Table>();
        nullFreeMutableList2 = new StringWrapperWithVoidRegions(string).split(CREATE_TABLE, false, false, false);
        for (String string2 : nullFreeMutableList2) {
            nullFreeMutableList.add(new Table(this.generationConfig, CREATE_TABLE + string2));
        }
        return nullFreeMutableList;
    }

    private void writeOutput(List<Table> list) throws Exception {
        StringBuffer stringBuffer = null;
        File file = null;
        stringBuffer = new StringBuffer();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(list.get(i));
            stringBuffer.append("\n");
        }
        file = new File(this.generationRoot, "tables.txt");
        FileMethods.writeTextFile(file, stringBuffer.toString());
    }

    private void copyToSrcLocations(File file) throws Exception {
        for (GenerationConfig.SrcLocationStruct srcLocationStruct : this.generationConfig.getSrcLocations()) {
            this.copyToSrcLocation(file, srcLocationStruct);
        }
    }

    private void copyToSrcLocation(File file, GenerationConfig.SrcLocationStruct srcLocationStruct) throws Exception {
        File[] fileArray = null;
        File file22 = null;
        File file3 = null;
        srcLocationStruct.directory.mkdirs();
        this.clearDestination(srcLocationStruct.directory, srcLocationStruct);
        for (File file22 : file.listFiles()) {
            file3 = new File(srcLocationStruct.directory, file22.getName());
            FileMethods.copyFileTo(file22, file3);
        }
    }

    private void clearDestination(File file, GenerationConfig.SrcLocationStruct srcLocationStruct) throws Exception {
        File[] fileArray = null;
        File file22 = null;
        for (File file22 : file.listFiles()) {
            if (!file22.isFile() || srcLocationStruct.exclusions.contains(file22.getName())) continue;
            file22.delete();
        }
    }
}

