/*
 * Decompiled with CFR 0.152.
 */
package com.jronimo.engines.dbrep;

import com.jronimo.exceptions.UnexpectedErrorException;
import com.jronimo.util.Logger;
import com.jronimo.util.Methods;

public final class FieldType {
    private static final Logger logger = Logger.getLogger(FieldType.class);
    public static final String TYPE_BOOLEAN = "Boolean";
    public static final String TYPE_BYTE = "Byte";
    public static final String TYPE_SHORT = "Short";
    public static final String TYPE_INTEGER = "Integer";
    public static final String TYPE_LONG = "Long";
    public static final String TYPE_FLOAT = "Float";
    public static final String TYPE_DOUBLE = "Double";
    public static final String TYPE_STRING = "String";
    public static final String TYPE_DATE = "Date";
    public static final String TYPE_DATE_TIME = "DateTime";
    public static final String TYPE_BYTE_ARRAY = "byte[]";
    private String dbType;
    private String javaType;
    private boolean isBoolean;
    private boolean isByte;
    private boolean isShort;
    private boolean isInteger;
    private boolean isLong;
    private boolean isFloat;
    private boolean isDouble;
    private boolean isString;
    private boolean isDate;
    private boolean isDateTime;
    private boolean isByteArray;
    private boolean isNull;

    public FieldType(String string) {
        String string2 = null;
        try {
            this.dbType = string;
            string2 = this.javaType = FieldType.getJavaType(string);
            if (string2.equals(TYPE_BYTE_ARRAY)) {
                string2 = "ByteArray";
            }
            Methods.getFieldViaReflection(FieldType.class, "is" + string2).set(this, Boolean.TRUE);
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException(exception);
        }
    }

    public String getDbType() {
        return this.dbType;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public boolean isBoolean() {
        return this.isBoolean;
    }

    public boolean isByte() {
        return this.isByte;
    }

    public boolean isShort() {
        return this.isShort;
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public boolean isLong() {
        return this.isLong;
    }

    public boolean isFloat() {
        return this.isFloat;
    }

    public boolean isDouble() {
        return this.isDouble;
    }

    public boolean isString() {
        return this.isString;
    }

    public boolean isDate() {
        return this.isDate;
    }

    public boolean isDateTime() {
        return this.isDateTime;
    }

    public boolean isByteArray() {
        return this.isByteArray;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public String toString() {
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer();
        stringBuffer.append("this.dbType: " + this.dbType);
        stringBuffer.append("; this.javaType: " + this.javaType);
        return stringBuffer.toString();
    }

    public static String getJavaType(String string) {
        String string2 = null;
        if (string.equals(TYPE_BOOLEAN)) {
            string2 = TYPE_BOOLEAN;
        } else if (string.equals("TinyInt")) {
            string2 = TYPE_BYTE;
        } else if (string.equals("SmallInt")) {
            string2 = TYPE_SHORT;
        } else if (string.equals("MediumInt") || string.equals("Int")) {
            string2 = TYPE_INTEGER;
        } else if (string.equals("BigInt")) {
            string2 = TYPE_LONG;
        } else if (string.equals(TYPE_FLOAT)) {
            string2 = TYPE_FLOAT;
        } else if (string.equals(TYPE_DOUBLE)) {
            string2 = TYPE_DOUBLE;
        } else if (string.startsWith("Decimal")) {
            string2 = TYPE_DOUBLE;
        } else if (string.startsWith("VarChar")) {
            string2 = TYPE_STRING;
        } else if (string.equals(TYPE_DATE)) {
            string2 = TYPE_DATE;
        } else if (string.equals(TYPE_DATE_TIME)) {
            string2 = TYPE_DATE_TIME;
        } else if (string.indexOf("Blob") >= 0) {
            string2 = TYPE_BYTE_ARRAY;
        } else {
            throw new UnexpectedErrorException("UNRECOGNIZED dbType: " + string);
        }
        return string2;
    }
}

